/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentBiMap<K, V>
implements Map<K, V> {
    protected final Map<K, V> forwardMap;
    protected final Map<V, K> reverseMap;

    public ConcurrentBiMap() {
        this(new ConcurrentHashMap(16, 0.5f, 1), new ConcurrentHashMap(16, 0.5f, 1));
    }

    protected ConcurrentBiMap(Map<K, V> forwardMap, Map<V, K> reverseMap) {
        this.forwardMap = forwardMap;
        this.reverseMap = reverseMap;
    }

    public Map<V, K> inverse() {
        return Collections.unmodifiableMap(this.reverseMap);
    }

    @Override
    public void clear() {
        this.forwardMap.clear();
        this.reverseMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forwardMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.reverseMap.containsKey(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.forwardMap.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.forwardMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.forwardMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.forwardMap.keySet();
    }

    @Override
    public synchronized V put(K key, V value) {
        K oldKey = this.reverseMap.get(value);
        if (oldKey != null && !key.equals(oldKey)) {
            throw new IllegalArgumentException(value + " is already bound in reverseMap to " + oldKey);
        }
        V oldVal = this.forwardMap.put(key, value);
        if (oldVal != null && !Objects.equals(this.reverseMap.remove(oldVal), key)) {
            throw new IllegalStateException();
        }
        this.reverseMap.put(value, key);
        return oldVal;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized V remove(Object key) {
        V oldVal = this.forwardMap.remove(key);
        if (oldVal == null) {
            return null;
        }
        K oldKey = this.reverseMap.remove(oldVal);
        if (oldKey == null || !oldKey.equals(key)) {
            throw new IllegalStateException();
        }
        return oldVal;
    }

    @Override
    public int size() {
        return this.forwardMap.size();
    }

    @Override
    public Collection<V> values() {
        return this.reverseMap.keySet();
    }
}

