/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.QueryState;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.FrameCompressor;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Message;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.ProtocolException;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.AuthenticateMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ReadyMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.SemanticVersion;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;

public class StartupMessage
extends Message.Request {
    public static final String CQL_VERSION = "CQL_VERSION";
    public static final String COMPRESSION = "COMPRESSION";
    public static final Message.Codec<StartupMessage> codec = new Message.Codec<StartupMessage>(){

        @Override
        public StartupMessage decode(ChannelBuffer body, int version) {
            return new StartupMessage(StartupMessage.upperCaseKeys(CBUtil.readStringMap(body)));
        }

        @Override
        public void encode(StartupMessage msg, ChannelBuffer dest, int version) {
            CBUtil.writeStringMap(msg.options, dest);
        }

        @Override
        public int encodedSize(StartupMessage msg, int version) {
            return CBUtil.sizeOfStringMap(msg.options);
        }
    };
    public final Map<String, String> options;

    public StartupMessage(Map<String, String> options) {
        super(Message.Type.STARTUP);
        this.options = options;
    }

    @Override
    public Message.Response execute(QueryState state) {
        ClientState cState = state.getClientState();
        String cqlVersion = this.options.get(CQL_VERSION);
        if (cqlVersion == null) {
            throw new ProtocolException("Missing value CQL_VERSION in STARTUP message");
        }
        try {
            cState.setCQLVersion(cqlVersion);
        }
        catch (InvalidRequestException e) {
            throw new ProtocolException(e.getMessage());
        }
        if (cState.getCQLVersion().compareTo(new SemanticVersion("2.99.0")) < 0) {
            throw new ProtocolException(String.format("CQL version %s is not supported by the binary protocol (supported version are >= 3.0.0)", cqlVersion));
        }
        if (this.options.containsKey(COMPRESSION)) {
            String compression = this.options.get(COMPRESSION).toLowerCase();
            if (compression.equals("snappy")) {
                if (FrameCompressor.SnappyCompressor.instance == null) {
                    throw new ProtocolException("This instance does not support Snappy compression");
                }
                this.connection.setCompressor(FrameCompressor.SnappyCompressor.instance);
            } else if (compression.equals("lz4")) {
                this.connection.setCompressor(FrameCompressor.LZ4Compressor.instance);
            } else {
                throw new ProtocolException(String.format("Unknown compression algorithm: %s", compression));
            }
        }
        if (DatabaseDescriptor.getAuthenticator().requireAuthentication()) {
            return new AuthenticateMessage(DatabaseDescriptor.getAuthenticator().getClass().getName());
        }
        return new ReadyMessage();
    }

    private static Map<String, String> upperCaseKeys(Map<String, String> options) {
        HashMap<String, String> newMap = new HashMap<String, String>(options.size());
        for (Map.Entry<String, String> entry : options.entrySet()) {
            newMap.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        return newMap;
    }

    public String toString() {
        return "STARTUP " + this.options;
    }
}

