/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.tools;

import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.Descriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableMetadata;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;

public class SSTableMetadataViewer {
    public static void main(String[] args) throws IOException {
        PrintStream out = System.out;
        if (args.length == 0) {
            out.println("Usage: sstablemetadata <sstable filenames>");
            System.exit(1);
        }
        for (String fname : args) {
            if (new File(fname).exists()) {
                Descriptor descriptor = Descriptor.fromFilename(fname);
                SSTableMetadata metadata = (SSTableMetadata)SSTableMetadata.serializer.deserialize((Descriptor)descriptor).left;
                out.printf("SSTable: %s%n", descriptor);
                out.printf("Partitioner: %s%n", metadata.partitioner);
                out.printf("Minimum timestamp: %s%n", metadata.minTimestamp);
                out.printf("Maximum timestamp: %s%n", metadata.maxTimestamp);
                out.printf("SSTable max local deletion time: %s%n", metadata.maxLocalDeletionTime);
                out.printf("Compression ratio: %s%n", metadata.compressionRatio);
                out.printf("Estimated droppable tombstones: %s%n", metadata.getEstimatedDroppableTombstoneRatio((int)(System.currentTimeMillis() / 1000L)));
                out.printf("SSTable Level: %d%n", metadata.sstableLevel);
                out.println(metadata.replayPosition);
                SSTableMetadataViewer.printHistograms(metadata, out);
                out.println("Estimated tombstone drop times:");
                for (Map.Entry<Double, Long> entry : metadata.estimatedTombstoneDropTime.getAsMap().entrySet()) {
                    out.printf("%-10s:%10s%n", entry.getKey().intValue(), entry.getValue());
                }
                continue;
            }
            out.println("No such file: " + fname);
        }
    }

    private static void printHistograms(SSTableMetadata metadata, PrintStream out) {
        long[] offsets = metadata.estimatedRowSize.getBucketOffsets();
        long[] ersh = metadata.estimatedRowSize.getBuckets(false);
        long[] ecch = metadata.estimatedColumnCount.getBuckets(false);
        out.println(String.format("%-10s%18s%18s", "Count", "Row Size", "Column Count"));
        for (int i = 0; i < offsets.length; ++i) {
            out.println(String.format("%-10d%18s%18s", offsets[i], i < ersh.length ? Long.valueOf(ersh[i]) : "", i < ecch.length ? Long.valueOf(ecch[i]) : ""));
        }
    }
}

