/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.thrift;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.TCustomNonblockingServerSocket;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.TServerFactory;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ThriftSessionManager;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransportException;

public class CustomTNonBlockingServer
extends TNonblockingServer {
    public CustomTNonBlockingServer(TNonblockingServer.Args args) {
        super((AbstractNonblockingServer.AbstractNonblockingServerArgs)args);
    }

    protected boolean requestInvoke(AbstractNonblockingServer.FrameBuffer frameBuffer) {
        TNonblockingSocket socket = (TNonblockingSocket)((CustomFrameBuffer)frameBuffer).getTransport();
        ThriftSessionManager.instance.setCurrentSocket(socket.getSocketChannel().socket().getRemoteSocketAddress());
        frameBuffer.invoke();
        return true;
    }

    public class CustomFrameBuffer
    extends AbstractNonblockingServer.FrameBuffer {
        public CustomFrameBuffer(TNonblockingTransport trans, SelectionKey selectionKey, AbstractNonblockingServer.AbstractSelectThread selectThread) {
            super((AbstractNonblockingServer)CustomTNonBlockingServer.this, trans, selectionKey, selectThread);
        }

        public TNonblockingTransport getTransport() {
            return this.trans_;
        }
    }

    public static class Factory
    implements TServerFactory {
        @Override
        public TServer buildTServer(TServerFactory.Args args) {
            TCustomNonblockingServerSocket serverTransport;
            if (DatabaseDescriptor.getClientEncryptionOptions().enabled) {
                throw new RuntimeException("Client SSL is not supported for non-blocking sockets. Please remove client ssl from the configuration.");
            }
            InetSocketAddress addr = args.addr;
            try {
                serverTransport = new TCustomNonblockingServerSocket(addr, args.keepAlive, args.sendBufferSize, args.recvBufferSize);
            }
            catch (TTransportException e) {
                throw new RuntimeException(String.format("Unable to create thrift socket to %s:%s", addr.getAddress(), addr.getPort()), e);
            }
            TNonblockingServer.Args serverArgs = (TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)new TNonblockingServer.Args((TNonblockingServerTransport)serverTransport).inputTransportFactory(args.inTransportFactory)).outputTransportFactory(args.outTransportFactory)).inputProtocolFactory(args.tProtocolFactory)).outputProtocolFactory(args.tProtocolFactory)).processor(args.processor);
            return new CustomTNonBlockingServer(serverArgs);
        }
    }
}

