/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming;

import com.netflix.astyanax.shaded.org.apache.cassandra.net.IVerbHandler;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationFinishedVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReplicationFinishedVerbHandler.class);

    public void doVerb(MessageIn msg, int id) {
        StorageService.instance.confirmReplication(msg.from);
        MessageOut response = new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE);
        if (logger.isDebugEnabled()) {
            logger.debug("Replying to " + id + "@" + msg.from);
        }
        MessagingService.instance().sendReply(response, id, msg.from);
    }
}

