/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.net.InetAddress;

public class ProgressInfo
implements Serializable {
    public final InetAddress peer;
    public final String fileName;
    public final Direction direction;
    public final long currentBytes;
    public final long totalBytes;

    public ProgressInfo(InetAddress peer, String fileName, Direction direction, long currentBytes, long totalBytes) {
        assert (totalBytes > 0L);
        this.peer = peer;
        this.fileName = fileName;
        this.direction = direction;
        this.currentBytes = currentBytes;
        this.totalBytes = totalBytes;
    }

    public boolean isCompleted() {
        return this.currentBytes == this.totalBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgressInfo that = (ProgressInfo)o;
        if (this.totalBytes != that.totalBytes) {
            return false;
        }
        if (this.direction != that.direction) {
            return false;
        }
        if (!this.fileName.equals(that.fileName)) {
            return false;
        }
        return this.peer.equals(that.peer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.peer, this.fileName, this.direction, this.totalBytes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.fileName);
        sb.append(" ").append(this.currentBytes);
        sb.append("/").append(this.totalBytes).append(" bytes");
        sb.append("(").append(this.currentBytes * 100L / this.totalBytes).append("%) ");
        sb.append(this.direction == Direction.OUT ? "sent to " : "received from ");
        sb.append(this.peer);
        return sb.toString();
    }

    public static enum Direction {
        OUT(0),
        IN(1);

        public final byte code;

        private Direction(int code) {
            this.code = (byte)code;
        }

        public static Direction fromByte(byte direction) {
            return direction == 0 ? OUT : IN;
        }
    }
}

