/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.AbstractRangeCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RangeSliceReply;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.IVerbHandler;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import com.netflix.astyanax.shaded.org.apache.cassandra.tracing.Tracing;

public class RangeSliceVerbHandler
implements IVerbHandler<AbstractRangeCommand> {
    @Override
    public void doVerb(MessageIn<AbstractRangeCommand> message, int id) {
        try {
            if (StorageService.instance.isBootstrapMode()) {
                throw new RuntimeException("Cannot service reads while bootstrapping!");
            }
            RangeSliceReply reply = new RangeSliceReply(((AbstractRangeCommand)message.payload).executeLocally());
            Tracing.trace("Enqueuing response to {}", message.from);
            MessagingService.instance().sendReply(reply.createMessage(), id, message.from);
        }
        catch (TombstoneOverwhelmingException reply) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

