/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.DefsTables;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.FailureDetector;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.IAsyncCallback;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.MigrationManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.WrappedRunnable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MigrationTask
extends WrappedRunnable {
    private static final Logger logger = LoggerFactory.getLogger(MigrationTask.class);
    private final InetAddress endpoint;

    MigrationTask(InetAddress endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void runMayThrow() throws Exception {
        if (!MigrationManager.shouldPullSchemaFrom(this.endpoint)) {
            logger.info("Skipped sending a migration request: node {} has a higher major version now.", (Object)this.endpoint);
            return;
        }
        if (!FailureDetector.instance.isAlive(this.endpoint)) {
            logger.debug("Can't send schema pull request: node {} is down.", (Object)this.endpoint);
            return;
        }
        MessageOut<Collection<RowMutation>> message = new MessageOut<Collection<RowMutation>>(MessagingService.Verb.MIGRATION_REQUEST, null, MigrationManager.MigrationsSerializer.instance);
        IAsyncCallback<Collection<RowMutation>> cb = new IAsyncCallback<Collection<RowMutation>>(){

            @Override
            public void response(MessageIn<Collection<RowMutation>> message) {
                try {
                    DefsTables.mergeSchema((Collection)message.payload);
                }
                catch (IOException e) {
                    logger.error("IOException merging remote schema", (Throwable)e);
                }
                catch (ConfigurationException e) {
                    logger.error("Configuration exception merging remote schema", (Throwable)e);
                }
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }
        };
        MessagingService.instance().sendRR(message, this.endpoint, cb);
    }
}

