/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.AbstractBounds;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Range;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.CompactEndpointSerializationHelper;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.RepairJobDesc;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.RepairMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;

public class SyncRequest
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new SyncRequestSerializer();
    public final InetAddress initiator;
    public final InetAddress src;
    public final InetAddress dst;
    public final Collection<Range<Token>> ranges;

    public SyncRequest(RepairJobDesc desc, InetAddress initiator, InetAddress src, InetAddress dst, Collection<Range<Token>> ranges) {
        super(RepairMessage.Type.SYNC_REQUEST, desc);
        this.initiator = initiator;
        this.src = src;
        this.dst = dst;
        this.ranges = ranges;
    }

    public static class SyncRequestSerializer
    implements RepairMessage.MessageSerializer<SyncRequest> {
        @Override
        public void serialize(SyncRequest message, DataOutput out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            CompactEndpointSerializationHelper.serialize(message.initiator, out);
            CompactEndpointSerializationHelper.serialize(message.src, out);
            CompactEndpointSerializationHelper.serialize(message.dst, out);
            out.writeInt(message.ranges.size());
            for (Range<Token> range : message.ranges) {
                AbstractBounds.serializer.serialize((AbstractBounds<?>)range, out, version);
            }
        }

        @Override
        public SyncRequest deserialize(DataInput in, int version) throws IOException {
            RepairJobDesc desc = RepairJobDesc.serializer.deserialize(in, version);
            InetAddress owner = CompactEndpointSerializationHelper.deserialize(in);
            InetAddress src = CompactEndpointSerializationHelper.deserialize(in);
            InetAddress dst = CompactEndpointSerializationHelper.deserialize(in);
            int rangesCount = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(rangesCount);
            for (int i = 0; i < rangesCount; ++i) {
                ranges.add((Range)((AbstractBounds)AbstractBounds.serializer.deserialize(in, version)).toTokenBounds());
            }
            return new SyncRequest(desc, owner, src, dst, ranges);
        }

        @Override
        public long serializedSize(SyncRequest message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += (long)(3 * CompactEndpointSerializationHelper.serializedSize(message.initiator));
            size += (long)TypeSizes.NATIVE.sizeof(message.ranges.size());
            for (Range<Token> range : message.ranges) {
                size += AbstractBounds.serializer.serializedSize((AbstractBounds<?>)range, version);
            }
            return size;
        }
    }
}

