/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.RepairJobDesc;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.SyncComplete;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.SyncRequest;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.ValidationComplete;
import com.netflix.astyanax.shaded.org.apache.cassandra.repair.messages.ValidationRequest;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class RepairMessage {
    public static final IVersionedSerializer<RepairMessage> serializer = new RepairMessageSerializer();
    public final Type messageType;
    public final RepairJobDesc desc;

    protected RepairMessage(Type messageType, RepairJobDesc desc) {
        this.messageType = messageType;
        this.desc = desc;
    }

    public MessageOut<RepairMessage> createMessage() {
        return new MessageOut<RepairMessage>(MessagingService.Verb.REPAIR_MESSAGE, this, serializer);
    }

    public static class RepairMessageSerializer
    implements IVersionedSerializer<RepairMessage> {
        @Override
        public void serialize(RepairMessage message, DataOutput out, int version) throws IOException {
            out.write(message.messageType.type);
            message.messageType.serializer.serialize(message, out, version);
        }

        @Override
        public RepairMessage deserialize(DataInput in, int version) throws IOException {
            Type messageType = Type.fromByte(in.readByte());
            return (RepairMessage)messageType.serializer.deserialize(in, version);
        }

        @Override
        public long serializedSize(RepairMessage message, int version) {
            long size = 1L;
            return size += message.messageType.serializer.serializedSize(message, version);
        }
    }

    public static enum Type {
        VALIDATION_REQUEST(0, ValidationRequest.serializer),
        VALIDATION_COMPLETE(1, ValidationComplete.serializer),
        SYNC_REQUEST(2, SyncRequest.serializer),
        SYNC_COMPLETE(3, SyncComplete.serializer);

        private final byte type;
        private final MessageSerializer<RepairMessage> serializer;

        private Type(int type, MessageSerializer<RepairMessage> serializer) {
            this.type = (byte)type;
            this.serializer = serializer;
        }

        public static Type fromByte(byte b) {
            for (Type t : Type.values()) {
                if (t.type != b) continue;
                return t;
            }
            throw new IllegalArgumentException("Unknown RepairMessage.Type: " + b);
        }
    }

    public static interface MessageSerializer<T extends RepairMessage>
    extends IVersionedSerializer<T> {
    }
}

