/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.locator;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.Config;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.SeedProvider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSeedProvider.class);
    List<InetAddress> seeds;

    public SimpleSeedProvider(Map<String, String> args) {
        try {
            this.seeds = this.loadSeeds();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public List<InetAddress> getSeeds() {
        try {
            this.seeds = this.loadSeeds();
        }
        catch (Exception e) {
            logger.warn("Could not refresh seeds from configuration file: {}", (Throwable)e);
        }
        return Collections.unmodifiableList(this.seeds);
    }

    private List<InetAddress> loadSeeds() throws IOException, ConfigurationException {
        Config conf = DatabaseDescriptor.loadConfig();
        String[] hosts = conf.seed_provider.parameters.get("seeds").split(",", -1);
        ArrayList<InetAddress> seeds = new ArrayList<InetAddress>(hosts.length);
        for (String host : hosts) {
            try {
                seeds.add(InetAddress.getByName(host.trim()));
            }
            catch (UnknownHostException ex) {
                logger.warn("Seed provider couldn't lookup host " + host);
            }
        }
        return seeds;
    }
}

