/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.locator;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class EndpointSnitchInfo
implements EndpointSnitchInfoMBean {
    public static void create() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(new EndpointSnitchInfo(), new ObjectName("com.netflix.astyanax.shaded.org.apache.cassandra.db:type=EndpointSnitchInfo"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDatacenter(String host) throws UnknownHostException {
        return DatabaseDescriptor.getEndpointSnitch().getDatacenter(InetAddress.getByName(host));
    }

    @Override
    public String getRack(String host) throws UnknownHostException {
        return DatabaseDescriptor.getEndpointSnitch().getRack(InetAddress.getByName(host));
    }

    @Override
    public String getSnitchName() {
        return DatabaseDescriptor.getEndpointSnitch().getClass().getName();
    }
}

