/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.util;

import com.netflix.astyanax.shaded.org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.compress.CompressionMetadata;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileDataInput;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.ICompressedFile;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.SegmentedFile;

public class CompressedSegmentedFile
extends SegmentedFile
implements ICompressedFile {
    public final CompressionMetadata metadata;

    public CompressedSegmentedFile(String path, CompressionMetadata metadata) {
        super(path, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
    }

    @Override
    public FileDataInput getSegment(long position) {
        CompressedRandomAccessReader reader = CompressedRandomAccessReader.open(this.path, this.metadata, null);
        reader.seek(position);
        return reader;
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void cleanup() {
        this.metadata.close();
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path) {
            return new CompressedSegmentedFile(path, CompressionMetadata.create(path));
        }
    }
}

