/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.util;

import com.netflix.astyanax.shaded.org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.compress.CompressionMetadata;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.ICompressedFile;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.PoolingSegmentedFile;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.RandomAccessReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.SegmentedFile;

public class CompressedPoolingSegmentedFile
extends PoolingSegmentedFile
implements ICompressedFile {
    public final CompressionMetadata metadata;

    public CompressedPoolingSegmentedFile(String path, CompressionMetadata metadata) {
        super(path, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
    }

    @Override
    protected RandomAccessReader createReader(String path) {
        return CompressedRandomAccessReader.open(path, this.metadata, this);
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.metadata.close();
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path) {
            return new CompressedPoolingSegmentedFile(path, CompressionMetadata.create(path));
        }
    }
}

