/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileDataInput;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileMark;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileUtils;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ObjectSizes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IndexHelper {
    public static void skipBloomFilter(DataInput in) throws IOException {
        int size = in.readInt();
        FileUtils.skipBytesFully(in, size);
    }

    public static void skipIndex(DataInput in) throws IOException {
        int columnIndexSize = in.readInt();
        if (in instanceof FileDataInput) {
            FileUtils.skipBytesFully(in, columnIndexSize);
        } else {
            byte[] skip = new byte[columnIndexSize];
            in.readFully(skip);
        }
    }

    public static List<IndexInfo> deserializeIndex(FileDataInput in) throws IOException {
        int columnIndexSize = in.readInt();
        if (columnIndexSize == 0) {
            return Collections.emptyList();
        }
        ArrayList<IndexInfo> indexList = new ArrayList<IndexInfo>();
        FileMark mark = in.mark();
        while (in.bytesPastMark(mark) < (long)columnIndexSize) {
            indexList.add(IndexInfo.deserialize(in));
        }
        assert (in.bytesPastMark(mark) == (long)columnIndexSize);
        return indexList;
    }

    public static int indexFor(ByteBuffer name, List<IndexInfo> indexList, AbstractType<?> comparator, boolean reversed, int lastIndex) {
        int index;
        if (name.remaining() == 0 && reversed) {
            return indexList.size() - 1;
        }
        if (lastIndex >= indexList.size()) {
            return -1;
        }
        IndexInfo target = new IndexInfo(name, name, 0L, 0L);
        int startIdx = 0;
        List<IndexInfo> toSearch = indexList;
        if (lastIndex >= 0) {
            if (reversed) {
                toSearch = indexList.subList(0, lastIndex + 1);
            } else {
                startIdx = lastIndex;
                toSearch = indexList.subList(lastIndex, indexList.size());
            }
        }
        return startIdx + ((index = Collections.binarySearch(toSearch, target, IndexHelper.getComparator(comparator, reversed))) < 0 ? -index - (reversed ? 2 : 1) : index);
    }

    public static Comparator<IndexInfo> getComparator(AbstractType<?> nameComparator, boolean reversed) {
        return reversed ? nameComparator.indexReverseComparator : nameComparator.indexComparator;
    }

    public static class IndexInfo {
        public final long width;
        public final ByteBuffer lastName;
        public final ByteBuffer firstName;
        public final long offset;

        public IndexInfo(ByteBuffer firstName, ByteBuffer lastName, long offset, long width) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.offset = offset;
            this.width = width;
        }

        public void serialize(DataOutput out) throws IOException {
            ByteBufferUtil.writeWithShortLength(this.firstName, out);
            ByteBufferUtil.writeWithShortLength(this.lastName, out);
            out.writeLong(this.offset);
            out.writeLong(this.width);
        }

        public int serializedSize(TypeSizes typeSizes) {
            int firstNameSize = this.firstName.remaining();
            int lastNameSize = this.lastName.remaining();
            return typeSizes.sizeof((short)firstNameSize) + firstNameSize + typeSizes.sizeof((short)lastNameSize) + lastNameSize + typeSizes.sizeof(this.offset) + typeSizes.sizeof(this.width);
        }

        public static IndexInfo deserialize(DataInput in) throws IOException {
            return new IndexInfo(ByteBufferUtil.readWithShortLength(in), ByteBufferUtil.readWithShortLength(in), in.readLong(), in.readLong());
        }

        public long memorySize() {
            return ObjectSizes.getFieldSize(ObjectSizes.getReferenceSize() + ObjectSizes.getReferenceSize() + TypeSizes.NATIVE.sizeof(this.offset) + TypeSizes.NATIVE.sizeof(this.width)) + ObjectSizes.getSize(this.firstName) + ObjectSizes.getSize(this.lastName);
        }
    }
}

