/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.gms;

import com.netflix.astyanax.shaded.org.apache.cassandra.dht.IPartitioner;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenSerializer {
    private static final Logger logger = LoggerFactory.getLogger(TokenSerializer.class);

    public static void serialize(IPartitioner partitioner, Collection<Token> tokens, DataOutput out) throws IOException {
        for (Token token : tokens) {
            byte[] bintoken = partitioner.getTokenFactory().toByteArray(token).array();
            out.writeInt(bintoken.length);
            out.write(bintoken);
        }
        out.writeInt(0);
    }

    public static Collection<Token> deserialize(IPartitioner partitioner, DataInput in) throws IOException {
        int size;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ((size = in.readInt()) >= 1) {
            logger.trace("Reading token of {} bytes", (Object)size);
            byte[] bintoken = new byte[size];
            in.readFully(bintoken);
            tokens.add(partitioner.getTokenFactory().fromByteArray(ByteBuffer.wrap(bintoken)));
        }
        return tokens;
    }
}

