/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.dht;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import java.nio.ByteBuffer;

public class LocalToken
extends Token<ByteBuffer> {
    static final long serialVersionUID = 8437543776403014875L;
    private final AbstractType<?> comparator;

    public LocalToken(AbstractType<?> comparator, ByteBuffer token) {
        super(token);
        this.comparator = comparator;
    }

    @Override
    public String toString() {
        return this.comparator.getString((ByteBuffer)this.token);
    }

    @Override
    public int compareTo(Token<ByteBuffer> o) {
        return this.comparator.compare(this.token, o.token);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 + ((ByteBuffer)this.token).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LocalToken)) {
            return false;
        }
        LocalToken other = (LocalToken)obj;
        return ((ByteBuffer)this.token).equals(other.token);
    }
}

