/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.google.common.base.Objects;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractCompositeType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TypeParser;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.SyntaxException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.BytesSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class TupleType
extends AbstractType<ByteBuffer> {
    protected final List<AbstractType<?>> types;

    public TupleType(List<AbstractType<?>> types) {
        this.types = types;
    }

    public static TupleType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        return new TupleType(parser.getTypeParameters());
    }

    public AbstractType<?> type(int i) {
        return this.types.get(i);
    }

    public int size() {
        return this.types.size();
    }

    public List<AbstractType<?>> allTypes() {
        return this.types;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        ByteBuffer bb1 = o1.duplicate();
        ByteBuffer bb2 = o2.duplicate();
        int i = 0;
        while (bb1.remaining() > 0 && bb2.remaining() > 0) {
            ByteBuffer value2;
            AbstractType<?> comparator = this.types.get(i);
            int size1 = bb1.getInt();
            int size2 = bb2.getInt();
            if (size1 < 0) {
                if (size2 < 0) continue;
                return -1;
            }
            if (size2 < 0) {
                return 1;
            }
            ByteBuffer value1 = ByteBufferUtil.readBytes(bb1, size1);
            int cmp = comparator.compare(value1, value2 = ByteBufferUtil.readBytes(bb2, size2));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        if (bb1.remaining() == 0) {
            return bb2.remaining() == 0 ? 0 : -1;
        }
        return 1;
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        ByteBuffer input = bytes.duplicate();
        for (int i = 0; i < this.size(); ++i) {
            if (!input.hasRemaining()) {
                return;
            }
            if (input.remaining() < 4) {
                throw new MarshalException(String.format("Not enough bytes to read size of %dth component", i));
            }
            int size = input.getInt();
            if (size < 0) {
                throw new MarshalException("Nulls are not yet supported inside tuple values");
            }
            if (input.remaining() < size) {
                throw new MarshalException(String.format("Not enough bytes to read %dth component", i));
            }
            ByteBuffer field = ByteBufferUtil.readBytes(input, size);
            this.types.get(i).validate(field);
        }
        if (input.hasRemaining()) {
            throw new MarshalException("Invalid remaining data after end of tuple value");
        }
    }

    public ByteBuffer[] split(ByteBuffer value) {
        ByteBuffer[] components = new ByteBuffer[this.size()];
        ByteBuffer input = value.duplicate();
        for (int i = 0; i < this.size(); ++i) {
            if (!input.hasRemaining()) {
                return Arrays.copyOfRange(components, 0, i);
            }
            int size = input.getInt();
            components[i] = size < 0 ? null : ByteBufferUtil.readBytes(input, size);
        }
        return components;
    }

    public static ByteBuffer buildValue(ByteBuffer[] components) {
        int totalLength = 0;
        for (ByteBuffer component : components) {
            totalLength += 4 + component.remaining();
        }
        ByteBuffer result = ByteBuffer.allocate(totalLength);
        for (ByteBuffer component : components) {
            result.putInt(component.remaining());
            result.put(component.duplicate());
        }
        result.rewind();
        return result;
    }

    @Override
    public String getString(ByteBuffer value) {
        StringBuilder sb = new StringBuilder();
        ByteBuffer input = value.duplicate();
        for (int i = 0; i < this.size(); ++i) {
            if (!input.hasRemaining()) {
                return sb.toString();
            }
            if (i > 0) {
                sb.append(":");
            }
            int size = input.getInt();
            assert (size >= 0);
            ByteBuffer field = ByteBufferUtil.readBytes(input, size);
            sb.append(field == null ? "null" : this.type(i).getString(value).replaceAll(":", "\\\\:"));
        }
        return sb.toString();
    }

    @Override
    public ByteBuffer fromString(String source) {
        List<String> strings = AbstractCompositeType.split(source);
        ByteBuffer[] components = new ByteBuffer[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            String str = strings.get(i).replaceAll("\\\\:", ":");
            components[i] = this.type(i).fromString(str);
        }
        return TupleType.buildValue(components);
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return BytesSerializer.instance;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (!(previous instanceof TupleType)) {
            return false;
        }
        TupleType tt = (TupleType)previous;
        if (this.size() < tt.size()) {
            return false;
        }
        for (int i = 0; i < tt.size(); ++i) {
            AbstractType<?> tprev = tt.type(i);
            AbstractType<?> tnew = this.type(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        if (!(otherType instanceof TupleType)) {
            return false;
        }
        TupleType tt = (TupleType)otherType;
        if (this.size() < tt.size()) {
            return false;
        }
        for (int i = 0; i < tt.size(); ++i) {
            AbstractType<?> tprev = tt.type(i);
            AbstractType<?> tnew = this.type(i);
            if (tnew.isValueCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.types});
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TupleType)) {
            return false;
        }
        TupleType that = (TupleType)o;
        return this.types.equals(that.types);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyTypeParameters(this.types);
    }
}

