/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.IPartitioner;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;

public class LocalByPartionerType<T extends Token>
extends AbstractType<ByteBuffer> {
    private final IPartitioner<T> partitioner;

    public LocalByPartionerType(IPartitioner<T> partitioner) {
        this.partitioner = partitioner;
    }

    @Override
    public ByteBuffer compose(ByteBuffer bytes) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public ByteBuffer decompose(ByteBuffer bytes) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return ByteBufferUtil.bytesToHex(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return RowPosition.forKey(o1, this.partitioner).compareTo(RowPosition.forKey(o2, this.partitioner));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        throw new IllegalStateException("You shouldn't be validating this.");
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }
}

