/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQL3Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.DecimalSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public class DecimalType
extends AbstractType<BigDecimal> {
    public static final DecimalType instance = new DecimalType();

    DecimalType() {
    }

    @Override
    public int compare(ByteBuffer bb0, ByteBuffer bb1) {
        if (bb0.remaining() == 0) {
            return bb1.remaining() == 0 ? 0 : -1;
        }
        if (bb1.remaining() == 0) {
            return 1;
        }
        return ((BigDecimal)this.compose(bb0)).compareTo((BigDecimal)this.compose(bb1));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        BigDecimal decimal;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            decimal = new BigDecimal(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make BigDecimal from '%s'", source), e);
        }
        return this.decompose(decimal);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DECIMAL;
    }

    @Override
    public TypeSerializer<BigDecimal> getSerializer() {
        return DecimalSerializer.instance;
    }
}

