/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQL3Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.CounterUpdateColumn;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractCommutativeType;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.CounterSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;

public class CounterColumnType
extends AbstractCommutativeType {
    public static final CounterColumnType instance = new CounterColumnType();

    CounterColumnType() {
    }

    @Override
    public boolean isCounter() {
        return true;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return ByteBufferUtil.bytesToHex(bytes);
    }

    @Override
    public Column createColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        return new CounterUpdateColumn(name, value, timestamp);
    }

    @Override
    public ByteBuffer fromString(String source) {
        return ByteBufferUtil.hexToBytes(source);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.COUNTER;
    }

    @Override
    public TypeSerializer<Long> getSerializer() {
        return CounterSerializer.instance;
    }
}

