/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQL3Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AsciiType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.UTF8Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.BytesSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Hex;
import java.nio.ByteBuffer;

public class BytesType
extends AbstractType<ByteBuffer> {
    public static final BytesType instance = new BytesType();

    BytesType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return BytesType.bytesCompare(o1, o2);
    }

    public static int bytesCompare(ByteBuffer o1, ByteBuffer o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) {
        try {
            return ByteBuffer.wrap(Hex.hexToBytes(source));
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        return this == previous || previous == AsciiType.instance || previous == UTF8Type.instance;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return true;
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.BLOB;
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return BytesSerializer.instance;
    }
}

