/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.filter;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletionInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;

public class ColumnCounter {
    protected int live;
    protected int tombstones;
    protected final long timestamp;

    public ColumnCounter(long timestamp) {
        this.timestamp = timestamp;
    }

    public void count(Column column, DeletionInfo.InOrderTester tester) {
        if (tester.isDeleted(column)) {
            return;
        }
        if (column.isLive(this.timestamp)) {
            ++this.live;
        } else {
            ++this.tombstones;
        }
    }

    public int live() {
        return this.live;
    }

    public int tombstones() {
        return this.tombstones;
    }

    public ColumnCounter countAll(ColumnFamily container) {
        if (container == null) {
            return this;
        }
        DeletionInfo.InOrderTester tester = container.inOrderDeletionTester();
        for (Column c : container) {
            this.count(c, tester);
        }
        return this;
    }

    public static class GroupByPrefixReversed
    extends GroupByPrefix {
        public GroupByPrefixReversed(long timestamp, CompositeType type, int toGroup) {
            super(timestamp, type, toGroup);
        }

        @Override
        public void count(Column column, DeletionInfo.InOrderTester tester) {
            if (tester.isDeleted(column)) {
                return;
            }
            if (!column.isLive(this.timestamp)) {
                ++this.tombstones;
                return;
            }
            if (this.toGroup == 0) {
                this.live = 1;
                return;
            }
            ByteBuffer[] current = this.type.split(column.name());
            assert (current.length >= this.toGroup);
            boolean isStatic = CompositeType.isStaticName(column.name());
            if (this.previous == null) {
                this.previousGroupIsStatic = true;
                this.previous = current;
                ++this.live;
            } else if (isStatic) {
                return;
            }
            for (int i = 0; i < this.toGroup; ++i) {
                if (ByteBufferUtil.compareUnsigned(this.previous[i], current[i]) == 0) continue;
                ++this.live;
                this.previous = current;
                return;
            }
        }
    }

    public static class GroupByPrefix
    extends ColumnCounter {
        protected final CompositeType type;
        protected final int toGroup;
        protected ByteBuffer[] previous;
        protected boolean previousGroupIsStatic;

        public GroupByPrefix(long timestamp, CompositeType type, int toGroup) {
            super(timestamp);
            this.type = type;
            this.toGroup = toGroup;
            assert (toGroup == 0 || type != null);
        }

        @Override
        public void count(Column column, DeletionInfo.InOrderTester tester) {
            if (tester.isDeleted(column)) {
                return;
            }
            if (!column.isLive(this.timestamp)) {
                ++this.tombstones;
                return;
            }
            if (this.toGroup == 0) {
                this.live = 1;
                return;
            }
            ByteBuffer[] current = this.type.split(column.name());
            assert (current.length >= this.toGroup);
            if (this.previous == null) {
                this.previousGroupIsStatic = CompositeType.isStaticName(column.name());
            } else {
                boolean isSameGroup;
                boolean bl = isSameGroup = this.previousGroupIsStatic == CompositeType.isStaticName(column.name());
                if (isSameGroup) {
                    for (int i = 0; i < this.toGroup; ++i) {
                        if (ByteBufferUtil.compareUnsigned(this.previous[i], current[i]) == 0) continue;
                        isSameGroup = false;
                        break;
                    }
                }
                if (isSameGroup) {
                    return;
                }
                if (this.previousGroupIsStatic) {
                    this.previous = current;
                    this.previousGroupIsStatic = false;
                    return;
                }
            }
            ++this.live;
            this.previous = current;
        }
    }
}

