/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator;

import com.google.common.collect.AbstractIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.OnDiskAtom;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.IColumnIteratorFactory;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import java.io.IOException;

public class LazyColumnIterator
extends AbstractIterator<OnDiskAtom>
implements OnDiskAtomIterator {
    private final DecoratedKey key;
    private final IColumnIteratorFactory subIteratorFactory;
    private OnDiskAtomIterator subIterator;

    public LazyColumnIterator(DecoratedKey key, IColumnIteratorFactory subIteratorFactory) {
        this.key = key;
        this.subIteratorFactory = subIteratorFactory;
    }

    private OnDiskAtomIterator getSubIterator() {
        if (this.subIterator == null) {
            this.subIterator = this.subIteratorFactory.create();
        }
        return this.subIterator;
    }

    protected OnDiskAtom computeNext() {
        this.getSubIterator();
        return this.subIterator.hasNext() ? (OnDiskAtom)this.subIterator.next() : (OnDiskAtom)this.endOfData();
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.getSubIterator().getColumnFamily();
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public void close() throws IOException {
        if (this.subIterator != null) {
            this.subIterator.close();
        }
    }
}

