/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.UUID;

public abstract class TypeSizes {
    public static final TypeSizes NATIVE = new NativeDBTypeSizes();
    public static final TypeSizes VINT = new VIntEncodedTypeSizes();
    private static final int BOOL_SIZE = 1;
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final int UUID_SIZE = 16;

    public abstract int sizeof(boolean var1);

    public abstract int sizeof(short var1);

    public abstract int sizeof(int var1);

    public abstract int sizeof(long var1);

    public abstract int sizeof(UUID var1);

    public int sizeof(String value) {
        int length = TypeSizes.encodedUTF8Length(value);
        assert (length <= Short.MAX_VALUE);
        return this.sizeof((short)length) + length;
    }

    public static int encodedUTF8Length(String st) {
        int strlen = st.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = st.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public int sizeofWithShortLength(ByteBuffer value) {
        return this.sizeof((short)value.remaining()) + value.remaining();
    }

    public int sizeofWithLength(ByteBuffer value) {
        return this.sizeof(value.remaining()) + value.remaining();
    }

    public static class VIntEncodedTypeSizes
    extends TypeSizes {
        private static final int BOOL_SIZE = 1;

        public int sizeofVInt(long i) {
            if (i >= -112L && i <= 127L) {
                return 1;
            }
            int size = 0;
            int len = -112;
            if (i < 0L) {
                i ^= 0xFFFFFFFFFFFFFFFFL;
                len = -120;
            }
            long tmp = i;
            while (tmp != 0L) {
                tmp >>= 8;
                --len;
            }
            ++size;
            len = len < -120 ? -(len + 120) : -(len + 112);
            return size += len;
        }

        @Override
        public int sizeof(long i) {
            return this.sizeofVInt(i);
        }

        @Override
        public int sizeof(boolean i) {
            return 1;
        }

        @Override
        public int sizeof(short i) {
            return this.sizeofVInt(i);
        }

        @Override
        public int sizeof(int i) {
            return this.sizeofVInt(i);
        }

        @Override
        public int sizeof(UUID value) {
            return this.sizeofVInt(value.getMostSignificantBits()) + this.sizeofVInt(value.getLeastSignificantBits());
        }
    }

    public static class NativeDBTypeSizes
    extends TypeSizes {
        @Override
        public int sizeof(boolean value) {
            return 1;
        }

        @Override
        public int sizeof(short value) {
            return 2;
        }

        @Override
        public int sizeof(int value) {
            return 4;
        }

        @Override
        public int sizeof(long value) {
            return 8;
        }

        @Override
        public int sizeof(UUID value) {
            return 16;
        }
    }
}

