/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ReadResponse;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.IVerbHandler;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import com.netflix.astyanax.shaded.org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadVerbHandler
implements IVerbHandler<ReadCommand> {
    private static final Logger logger = LoggerFactory.getLogger(ReadVerbHandler.class);

    @Override
    public void doVerb(MessageIn<ReadCommand> message, int id) {
        Row row;
        if (StorageService.instance.isBootstrapMode()) {
            throw new RuntimeException("Cannot service reads while bootstrapping!");
        }
        ReadCommand command = (ReadCommand)message.payload;
        Keyspace keyspace = Keyspace.open(command.ksName);
        try {
            row = command.getRow(keyspace);
        }
        catch (TombstoneOverwhelmingException e) {
            return;
        }
        MessageOut<ReadResponse> reply = new MessageOut<ReadResponse>(MessagingService.Verb.REQUEST_RESPONSE, ReadVerbHandler.getResponse(command, row), ReadResponse.serializer);
        Tracing.trace("Enqueuing response to {}", message.from);
        MessagingService.instance().sendReply(reply, id, message.from);
    }

    public static ReadResponse getResponse(ReadCommand command, Row row) {
        if (command.isDigestQuery()) {
            return new ReadResponse(ColumnFamily.digest(row.cf));
        }
        return new ReadResponse(row);
    }
}

