/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ReadCommandSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SliceByNamesReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SliceFromReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.IDiskAtomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.NamesQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.SliceQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.IReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.RowDataResolver;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.Pageable;
import java.nio.ByteBuffer;

public abstract class ReadCommand
implements IReadCommand,
Pageable {
    public static final ReadCommandSerializer serializer = new ReadCommandSerializer();
    public final String ksName;
    public final String cfName;
    public final ByteBuffer key;
    public final long timestamp;
    private boolean isDigestQuery = false;
    protected final Type commandType;

    public MessageOut<ReadCommand> createMessage() {
        return new MessageOut<ReadCommand>(MessagingService.Verb.READ, this, serializer);
    }

    protected ReadCommand(String ksName, ByteBuffer key, String cfName, long timestamp, Type cmdType) {
        this.ksName = ksName;
        this.key = key;
        this.cfName = cfName;
        this.timestamp = timestamp;
        this.commandType = cmdType;
    }

    public static ReadCommand create(String ksName, ByteBuffer key, String cfName, long timestamp, IDiskAtomFilter filter) {
        if (filter instanceof SliceQueryFilter) {
            return new SliceFromReadCommand(ksName, key, cfName, timestamp, (SliceQueryFilter)filter);
        }
        return new SliceByNamesReadCommand(ksName, key, cfName, timestamp, (NamesQueryFilter)filter);
    }

    public boolean isDigestQuery() {
        return this.isDigestQuery;
    }

    public void setDigestQuery(boolean isDigestQuery) {
        this.isDigestQuery = isDigestQuery;
    }

    public String getColumnFamilyName() {
        return this.cfName;
    }

    public abstract ReadCommand copy();

    public abstract Row getRow(Keyspace var1);

    public abstract IDiskAtomFilter filter();

    @Override
    public String getKeyspace() {
        return this.ksName;
    }

    public ReadCommand maybeGenerateRetryCommand(RowDataResolver resolver, Row row) {
        return null;
    }

    public void maybeTrim(Row row) {
    }

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout();
    }

    public static enum Type {
        GET_BY_NAMES(1),
        GET_SLICES(2);

        public final byte serializedValue;

        private Type(byte b) {
            this.serializedValue = b;
        }

        public static Type fromSerializedValue(byte b) {
            return b == 1 ? GET_BY_NAMES : GET_SLICES;
        }
    }
}

