/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FastByteArrayInputStream;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RangeSliceReply {
    public static final RangeSliceReplySerializer serializer = new RangeSliceReplySerializer();
    public final List<Row> rows;

    public RangeSliceReply(List<Row> rows) {
        this.rows = rows;
    }

    public MessageOut<RangeSliceReply> createMessage() {
        return new MessageOut<RangeSliceReply>(MessagingService.Verb.REQUEST_RESPONSE, this, serializer);
    }

    public String toString() {
        return "RangeSliceReply{rows=" + StringUtils.join(this.rows, (String)",") + '}';
    }

    public static RangeSliceReply read(byte[] body, int version) throws IOException {
        return serializer.deserialize(new DataInputStream(new FastByteArrayInputStream(body)), version);
    }

    private static class RangeSliceReplySerializer
    implements IVersionedSerializer<RangeSliceReply> {
        private RangeSliceReplySerializer() {
        }

        @Override
        public void serialize(RangeSliceReply rsr, DataOutput out, int version) throws IOException {
            out.writeInt(rsr.rows.size());
            for (Row row : rsr.rows) {
                Row.serializer.serialize(row, out, version);
            }
        }

        @Override
        public RangeSliceReply deserialize(DataInput in, int version) throws IOException {
            int rowCount = in.readInt();
            ArrayList<Row> rows = new ArrayList<Row>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                rows.add(Row.serializer.deserialize(in, version));
            }
            return new RangeSliceReply(rows);
        }

        @Override
        public long serializedSize(RangeSliceReply rsr, int version) {
            int size = TypeSizes.NATIVE.sizeof(rsr.rows.size());
            for (Row row : rsr.rows) {
                size = (int)((long)size + Row.serializer.serializedSize(row, version));
            }
            return size;
        }
    }
}

