/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletedColumn;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.context.CounterContext;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.context.IContext;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.DataOutputBuffer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Allocator;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.CounterId;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.HeapAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterColumn
extends Column {
    private static final Logger logger = LoggerFactory.getLogger(CounterColumn.class);
    protected static final CounterContext contextManager = CounterContext.instance();
    private final long timestampOfLastDelete;

    public CounterColumn(ByteBuffer name, long value, long timestamp) {
        this(name, contextManager.createLocal(value, HeapAllocator.instance), timestamp);
    }

    public CounterColumn(ByteBuffer name, long value, long timestamp, long timestampOfLastDelete) {
        this(name, contextManager.createLocal(value, HeapAllocator.instance), timestamp, timestampOfLastDelete);
    }

    public CounterColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        this(name, value, timestamp, Long.MIN_VALUE);
    }

    public CounterColumn(ByteBuffer name, ByteBuffer value, long timestamp, long timestampOfLastDelete) {
        super(name, value, timestamp);
        this.timestampOfLastDelete = timestampOfLastDelete;
    }

    public static CounterColumn create(ByteBuffer name, ByteBuffer value, long timestamp, long timestampOfLastDelete, ColumnSerializer.Flag flag) {
        if (flag == ColumnSerializer.Flag.FROM_REMOTE || flag == ColumnSerializer.Flag.LOCAL && contextManager.shouldClearLocal(value)) {
            value = contextManager.clearAllLocal(value);
        }
        return new CounterColumn(name, value, timestamp, timestampOfLastDelete);
    }

    @Override
    public Column withUpdatedName(ByteBuffer newName) {
        return new CounterColumn(newName, this.value, this.timestamp, this.timestampOfLastDelete);
    }

    public long timestampOfLastDelete() {
        return this.timestampOfLastDelete;
    }

    public long total() {
        return contextManager.total(this.value);
    }

    @Override
    public int dataSize() {
        return super.dataSize() + TypeSizes.NATIVE.sizeof(this.timestampOfLastDelete);
    }

    @Override
    public int serializedSize(TypeSizes typeSizes) {
        return super.serializedSize(typeSizes) + typeSizes.sizeof(this.timestampOfLastDelete);
    }

    @Override
    public Column diff(Column column) {
        assert (column instanceof CounterColumn || column instanceof DeletedColumn) : "Wrong class type: " + column.getClass();
        if (this.timestamp() < column.timestamp()) {
            return column;
        }
        assert (!(column instanceof DeletedColumn)) : "Wrong class type: " + column.getClass();
        if (this.timestampOfLastDelete() < ((CounterColumn)column).timestampOfLastDelete()) {
            return column;
        }
        IContext.ContextRelationship rel = contextManager.diff(column.value(), this.value());
        if (IContext.ContextRelationship.GREATER_THAN == rel || IContext.ContextRelationship.DISJOINT == rel) {
            return column;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.duplicate());
        contextManager.updateDigest(digest, this.value);
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.serializationFlags());
            buffer.writeLong(this.timestampOfLastDelete);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public Column reconcile(Column column, Allocator allocator) {
        assert (column instanceof CounterColumn || column instanceof DeletedColumn) : "Wrong class type: " + column.getClass();
        if (column.isMarkedForDelete(Long.MIN_VALUE)) {
            if (this.timestamp() < column.timestamp()) {
                return column;
            }
            if (this.timestampOfLastDelete() >= column.timestamp()) {
                return this;
            }
            return new CounterColumn(this.name(), this.value(), this.timestamp(), column.timestamp());
        }
        if (this.timestamp() < ((CounterColumn)column).timestampOfLastDelete()) {
            return column;
        }
        if (this.timestampOfLastDelete() > column.timestamp()) {
            return this;
        }
        return new CounterColumn(this.name(), contextManager.merge(this.value(), column.value(), allocator), Math.max(this.timestamp(), column.timestamp()), Math.max(this.timestampOfLastDelete(), ((CounterColumn)column).timestampOfLastDelete()));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.timestampOfLastDelete == ((CounterColumn)o).timestampOfLastDelete;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.timestampOfLastDelete ^ this.timestampOfLastDelete >>> 32);
        return result;
    }

    @Override
    public Column localCopy(ColumnFamilyStore cfs) {
        return new CounterColumn(cfs.internOrCopy(this.name, HeapAllocator.instance), ByteBufferUtil.clone(this.value), this.timestamp, this.timestampOfLastDelete);
    }

    @Override
    public Column localCopy(ColumnFamilyStore cfs, Allocator allocator) {
        return new CounterColumn(cfs.internOrCopy(this.name, allocator), allocator.clone(this.value), this.timestamp, this.timestampOfLastDelete);
    }

    @Override
    public String getString(AbstractType<?> comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(comparator.getString(this.name));
        sb.append(":");
        sb.append(false);
        sb.append(":");
        sb.append(contextManager.toString(this.value));
        sb.append("@");
        sb.append(this.timestamp());
        sb.append("!");
        sb.append(this.timestampOfLastDelete);
        return sb.toString();
    }

    @Override
    public int serializationFlags() {
        return 4;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        contextManager.validateContext(this.value());
    }

    public boolean hasCounterId(CounterId id) {
        return contextManager.hasCounterId(this.value(), id);
    }

    public Column markLocalToBeCleared() {
        ByteBuffer marked = contextManager.markLocalToBeCleared(this.value);
        return marked == this.value ? this : new CounterColumn(this.name, marked, this.timestamp, this.timestampOfLastDelete);
    }
}

