/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.IDiskAtomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.SliceQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.AbstractBounds;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.IReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.IndexExpression;
import java.util.List;

public abstract class AbstractRangeCommand
implements IReadCommand {
    public final String keyspace;
    public final String columnFamily;
    public final long timestamp;
    public final AbstractBounds<RowPosition> keyRange;
    public final IDiskAtomFilter predicate;
    public final List<IndexExpression> rowFilter;

    public AbstractRangeCommand(String keyspace, String columnFamily, long timestamp, AbstractBounds<RowPosition> keyRange, IDiskAtomFilter predicate, List<IndexExpression> rowFilter) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.timestamp = timestamp;
        this.keyRange = keyRange;
        this.predicate = predicate;
        this.rowFilter = rowFilter;
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public abstract MessageOut<? extends AbstractRangeCommand> createMessage();

    public abstract AbstractRangeCommand forSubRange(AbstractBounds<RowPosition> var1);

    public abstract AbstractRangeCommand withUpdatedLimit(int var1);

    public abstract int limit();

    public abstract boolean countCQL3Rows();

    public boolean ignoredTombstonedPartitions() {
        if (!(this.predicate instanceof SliceQueryFilter)) {
            return false;
        }
        return ((SliceQueryFilter)this.predicate).compositesToGroup == -2;
    }

    public abstract List<Row> executeLocally();

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout();
    }
}

