/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnSpecification;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ResultSet;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.SelectionColumns;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.LongType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SelectionColumnMapping
implements SelectionColumns {
    private final ArrayList<ColumnSpecification> columnSpecifications = new ArrayList();
    private final HashMultimap<ColumnSpecification, CFDefinition.Name> columnMappings = HashMultimap.create();

    private SelectionColumnMapping() {
    }

    protected static SelectionColumnMapping newMapping() {
        return new SelectionColumnMapping();
    }

    protected static SelectionColumnMapping countMapping(CFDefinition cfDef, ColumnIdentifier countAlias) {
        ColumnSpecification spec = new ColumnSpecification(cfDef.cfm.ksName, cfDef.cfm.cfName, countAlias == null ? ResultSet.COUNT_COLUMN : countAlias, LongType.instance);
        return new SelectionColumnMapping().addMapping(spec, Collections.emptyList());
    }

    protected static SelectionColumnMapping simpleMapping(Iterable<CFDefinition.Name> columnDefinitions) {
        SelectionColumnMapping mapping = new SelectionColumnMapping();
        for (CFDefinition.Name def : columnDefinitions) {
            mapping.addMapping((ColumnSpecification)def, def);
        }
        return mapping;
    }

    protected SelectionColumnMapping addMapping(ColumnSpecification colSpec, CFDefinition.Name column) {
        this.columnSpecifications.add(colSpec);
        if (column != null) {
            this.columnMappings.put((Object)colSpec, (Object)column);
        }
        return this;
    }

    protected SelectionColumnMapping addMapping(ColumnSpecification colSpec, Iterable<CFDefinition.Name> columns) {
        this.columnSpecifications.add(colSpec);
        this.columnMappings.putAll((Object)colSpec, columns);
        return this;
    }

    @Override
    public List<ColumnSpecification> getColumnSpecifications() {
        return Lists.newArrayList(this.columnSpecifications);
    }

    @Override
    public Multimap<ColumnSpecification, CFDefinition.Name> getMappings() {
        return Multimaps.unmodifiableMultimap(this.columnMappings);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectionColumns)) {
            return false;
        }
        SelectionColumns other = (SelectionColumns)obj;
        return Objects.equals(this.columnMappings, other.getMappings()) && Objects.equals(this.columnSpecifications, other.getColumnSpecifications());
    }

    public int hashCode() {
        return Objects.hashCode(this.columnMappings);
    }

    public String toString() {
        Function<CFDefinition.Name, String> getDefName = new Function<CFDefinition.Name, String>(){

            public String apply(CFDefinition.Name name) {
                return name.toString();
            }
        };
        Function<Map.Entry<ColumnSpecification, Collection<CFDefinition.Name>>, String> mappingEntryToString = new Function<Map.Entry<ColumnSpecification, Collection<CFDefinition.Name>>, String>((Function)getDefName){
            final /* synthetic */ Function val$getDefName;
            {
                this.val$getDefName = function;
            }

            public String apply(Map.Entry<ColumnSpecification, Collection<CFDefinition.Name>> entry) {
                StringBuilder builder = new StringBuilder();
                builder.append(entry.getKey().name.toString());
                builder.append(":[");
                builder.append(Joiner.on((char)',').join(Iterables.transform((Iterable)entry.getValue(), (Function)this.val$getDefName)));
                builder.append("]");
                return builder.toString();
            }
        };
        Function<ColumnSpecification, String> colSpecToString = new Function<ColumnSpecification, String>(){

            public String apply(ColumnSpecification columnSpecification) {
                return columnSpecification.name.toString();
            }
        };
        StringBuilder builder = new StringBuilder();
        builder.append("{ Columns:[");
        builder.append(Joiner.on((String)",").join(Iterables.transform(this.columnSpecifications, (Function)colSpecToString)));
        builder.append("], Mappings:[");
        builder.append(Joiner.on((String)", ").join(Iterables.transform(this.columnMappings.asMap().entrySet(), (Function)mappingEntryToString)));
        builder.append("] }");
        return builder.toString();
    }
}

