/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import java.util.ArrayList;
import java.util.List;

public interface Selectable {

    public static class WithFunction
    implements Selectable {
        public final String functionName;
        public final List<Selectable> args;

        public WithFunction(String functionName, List<Selectable> args) {
            this.functionName = functionName;
            this.args = args;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.functionName).append("(");
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.args.get(i));
            }
            return sb.append(")").toString();
        }

        public static class Raw
        implements com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.Selectable$Raw {
            private final String functionName;
            private final List<com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.Selectable$Raw> args;

            public Raw(String functionName, List<com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.Selectable$Raw> args) {
                this.functionName = functionName;
                this.args = args;
            }

            @Override
            public WithFunction prepare(CFMetaData cfm) {
                ArrayList<Selectable> preparedArgs = new ArrayList<Selectable>(this.args.size());
                for (com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.Selectable$Raw arg : this.args) {
                    preparedArgs.add(arg.prepare(cfm));
                }
                return new WithFunction(this.functionName, preparedArgs);
            }

            @Override
            public boolean processesSelection() {
                return true;
            }
        }
    }

    public static class WritetimeOrTTL
    implements Selectable {
        public final ColumnIdentifier id;
        public final boolean isWritetime;

        public WritetimeOrTTL(ColumnIdentifier id, boolean isWritetime) {
            this.id = id;
            this.isWritetime = isWritetime;
        }

        public String toString() {
            return (this.isWritetime ? "writetime" : "ttl") + "(" + this.id + ")";
        }

        public static class Raw
        implements com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.Selectable$Raw {
            private final ColumnIdentifier.Raw id;
            private final boolean isWritetime;

            public Raw(ColumnIdentifier.Raw id, boolean isWritetime) {
                this.id = id;
                this.isWritetime = isWritetime;
            }

            @Override
            public WritetimeOrTTL prepare(CFMetaData cfm) {
                return new WritetimeOrTTL(this.id.prepare(cfm), this.isWritetime);
            }

            @Override
            public boolean processesSelection() {
                return true;
            }
        }
    }

    public static interface Raw {
        public Selectable prepare(CFMetaData var1);

        public boolean processesSelection();
    }
}

