/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.PropertyDefinitions;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.SyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IndexPropDefs
extends PropertyDefinitions {
    public static final String KW_OPTIONS = "options";
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> obsoleteKeywords = new HashSet<String>();
    public boolean isCustom;
    public String customClass;

    public void validate() throws RequestValidationException {
        this.validate(keywords, obsoleteKeywords);
        if (this.isCustom && this.customClass == null) {
            throw new InvalidRequestException("CUSTOM index requires specifiying the index class");
        }
        if (!this.isCustom && this.customClass != null) {
            throw new InvalidRequestException("Cannot specify index class for a non-CUSTOM index");
        }
        if (!this.isCustom && !this.properties.isEmpty()) {
            throw new InvalidRequestException("Cannot specify options for a non-CUSTOM index");
        }
        if (this.getRawOptions().containsKey("class_name")) {
            throw new InvalidRequestException(String.format("Cannot specify %s as a CUSTOM option", "class_name"));
        }
    }

    public Map<String, String> getRawOptions() throws SyntaxException {
        Map<String, String> options = this.getMap(KW_OPTIONS);
        return options == null ? Collections.emptyMap() : options;
    }

    public Map<String, String> getOptions() throws SyntaxException {
        HashMap<String, String> options = new HashMap<String, String>(this.getRawOptions());
        options.put("class_name", this.customClass);
        return options;
    }

    static {
        keywords.add(KW_OPTIONS);
    }
}

