/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Permission;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFName;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.MigrationManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;

public class DropTableStatement
extends SchemaAlteringStatement {
    private final boolean ifExists;

    public DropTableStatement(CFName name, boolean ifExists) {
        super(name);
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        block2: {
            try {
                state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.DROP);
            }
            catch (InvalidRequestException e) {
                if (this.ifExists) break block2;
                throw e;
            }
        }
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public boolean announceMigration() throws ConfigurationException {
        try {
            MigrationManager.announceColumnFamilyDrop(this.keyspace(), this.columnFamily());
            return true;
        }
        catch (ConfigurationException e) {
            if (this.ifExists) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.DROPPED;
    }
}

