/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnCondition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnNameBuilder;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ColumnSlice;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.IDiskAtomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.SliceQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.CASConditions;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CQL3CasConditions
implements CASConditions {
    private final CFMetaData cfm;
    private final long now;
    private final SortedMap<ByteBuffer, RowCondition> conditions;

    public CQL3CasConditions(CFMetaData cfm, long now) {
        this.cfm = cfm;
        this.now = now / 1000L;
        this.conditions = new TreeMap<ByteBuffer, RowCondition>(cfm.comparator);
    }

    public void addNotExist(ColumnNameBuilder prefix) throws InvalidRequestException {
        RowCondition previous = this.conditions.put(prefix.build(), new NotExistCondition(prefix, this.now));
        if (previous != null && !(previous instanceof NotExistCondition)) {
            if (previous instanceof ExistCondition) {
                throw new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row");
            }
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
    }

    public void addExist(ColumnNameBuilder prefix) throws InvalidRequestException {
        RowCondition previous = this.conditions.put(prefix.build(), new ExistCondition(prefix, this.now));
        if (previous != null && previous instanceof NotExistCondition) {
            throw new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row");
        }
    }

    public void addConditions(ColumnNameBuilder prefix, Collection<ColumnCondition> conds, List<ByteBuffer> variables) throws InvalidRequestException {
        ByteBuffer b = prefix.build();
        RowCondition condition = (RowCondition)this.conditions.get(b);
        if (condition == null) {
            condition = new ColumnsConditions(prefix, this.now);
            this.conditions.put(b, condition);
        } else if (!(condition instanceof ColumnsConditions)) {
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
        ((ColumnsConditions)condition).addConditions(conds, variables);
    }

    @Override
    public IDiskAtomFilter readFilter() {
        assert (!this.conditions.isEmpty());
        ColumnSlice[] slices = new ColumnSlice[this.conditions.size()];
        int i = 0;
        for (Map.Entry<ByteBuffer, RowCondition> entry : this.conditions.entrySet()) {
            slices[i++] = new ColumnSlice(entry.getKey(), entry.getValue().rowPrefix.buildAsEndOfRange());
        }
        int toGroup = this.cfm.getCfDef().isCompact ? -1 : this.cfm.clusteringKeyColumns().size();
        return new SliceQueryFilter(slices, false, slices.length, toGroup);
    }

    @Override
    public boolean appliesTo(ColumnFamily current) throws InvalidRequestException {
        for (RowCondition condition : this.conditions.values()) {
            if (condition.appliesTo(current)) continue;
            return false;
        }
        return true;
    }

    private static class ColumnsConditions
    extends RowCondition {
        private final Map<Pair<ColumnIdentifier, ByteBuffer>, ColumnCondition.Bound> conditions = new HashMap<Pair<ColumnIdentifier, ByteBuffer>, ColumnCondition.Bound>();

        private ColumnsConditions(ColumnNameBuilder rowPrefix, long now) {
            super(rowPrefix, now);
        }

        public void addConditions(Collection<ColumnCondition> conds, List<ByteBuffer> variables) throws InvalidRequestException {
            for (ColumnCondition condition : conds) {
                ColumnCondition.Bound current = condition.bind(variables);
                ColumnCondition.Bound previous = this.conditions.put(Pair.create(condition.column.name, current.getCollectionElementValue()), current);
                if (previous == null || previous.equals(current)) continue;
                throw new InvalidRequestException("Duplicate and incompatible conditions for column " + condition.column.name);
            }
        }

        @Override
        public boolean appliesTo(ColumnFamily current) throws InvalidRequestException {
            if (current == null) {
                return this.conditions.isEmpty();
            }
            for (ColumnCondition.Bound condition : this.conditions.values()) {
                if (condition.appliesTo(this.rowPrefix, current, this.now)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ExistCondition
    extends RowCondition {
        private ExistCondition(ColumnNameBuilder rowPrefix, long now) {
            super(rowPrefix, now);
        }

        @Override
        public boolean appliesTo(ColumnFamily current) {
            if (current == null) {
                return false;
            }
            Iterator<Column> iter = current.iterator(new ColumnSlice[]{new ColumnSlice(this.rowPrefix.build(), this.rowPrefix.buildAsEndOfRange())});
            while (iter.hasNext()) {
                if (!iter.next().isLive(this.now)) continue;
                return true;
            }
            return false;
        }
    }

    private static class NotExistCondition
    extends RowCondition {
        private NotExistCondition(ColumnNameBuilder rowPrefix, long now) {
            super(rowPrefix, now);
        }

        @Override
        public boolean appliesTo(ColumnFamily current) {
            if (current == null) {
                return true;
            }
            Iterator<Column> iter = current.iterator(new ColumnSlice[]{new ColumnSlice(this.rowPrefix.build(), this.rowPrefix.buildAsEndOfRange())});
            while (iter.hasNext()) {
                if (!iter.next().isLive(this.now)) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class RowCondition {
        public final ColumnNameBuilder rowPrefix;
        protected final long now;

        protected RowCondition(ColumnNameBuilder rowPrefix, long now) {
            this.rowPrefix = rowPrefix;
            this.now = now;
        }

        public abstract boolean appliesTo(ColumnFamily var1) throws InvalidRequestException;
    }
}

