/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.functions;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.functions.AbstractFunction;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.functions.Function;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.LongType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TimeUUIDType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TimestampType;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.UUIDGen;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;

public abstract class TimeuuidFcts {
    public static final Function nowFct = new AbstractFunction("now", (AbstractType)TimeUUIDType.instance, new AbstractType[0]){

        @Override
        public ByteBuffer execute(List<ByteBuffer> parameters) {
            return ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes());
        }

        @Override
        public boolean isPure() {
            return false;
        }
    };
    public static final Function minTimeuuidFct = new AbstractFunction("mintimeuuid", (AbstractType)TimeUUIDType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return ByteBuffer.wrap(UUIDGen.decompose(UUIDGen.minTimeUUID(((Date)TimestampType.instance.compose(bb)).getTime())));
        }
    };
    public static final Function maxTimeuuidFct = new AbstractFunction("maxtimeuuid", (AbstractType)TimeUUIDType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return ByteBuffer.wrap(UUIDGen.decompose(UUIDGen.maxTimeUUID(((Date)TimestampType.instance.compose(bb)).getTime())));
        }
    };
    public static final Function dateOfFct = new AbstractFunction("dateof", (AbstractType)TimestampType.instance, new AbstractType[]{TimeUUIDType.instance}){

        @Override
        public ByteBuffer execute(List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return TimestampType.instance.decompose(new Date(UUIDGen.unixTimestamp(UUIDGen.getUUID(bb))));
        }
    };
    public static final Function unixTimestampOfFct = new AbstractFunction("unixtimestampof", (AbstractType)LongType.instance, new AbstractType[]{TimeUUIDType.instance}){

        @Override
        public ByteBuffer execute(List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return ByteBufferUtil.bytes(UUIDGen.unixTimestamp(UUIDGen.getUUID(bb)));
        }
    };
}

