/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Permission;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql.AbstractModification;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql.Attributes;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql.QueryProcessor;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql.Term;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.IMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ThriftClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ThriftValidation;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DeleteStatement
extends AbstractModification {
    private List<Term> columns;
    private List<Term> keys;

    public DeleteStatement(List<Term> columns, String keyspace, String columnFamily, String keyName, List<Term> keys, Attributes attrs) {
        super(keyspace, columnFamily, keyName, attrs);
        this.columns = columns;
        this.keys = keys;
    }

    public List<Term> getColumns() {
        return this.columns;
    }

    public List<Term> getKeys() {
        return this.keys;
    }

    @Override
    public List<IMutation> prepareRowMutations(String keyspace, ThriftClientState clientState, List<ByteBuffer> variables) throws InvalidRequestException, UnauthorizedException {
        return this.prepareRowMutations(keyspace, clientState, null, variables);
    }

    @Override
    public List<IMutation> prepareRowMutations(String keyspace, ThriftClientState clientState, Long timestamp, List<ByteBuffer> variables) throws InvalidRequestException, UnauthorizedException {
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, this.columnFamily);
        clientState.hasColumnFamilyAccess(keyspace, this.columnFamily, Permission.MODIFY);
        AbstractType<?> keyType = Schema.instance.getCFMetaData(keyspace, this.columnFamily).getKeyValidator();
        ArrayList<IMutation> rowMutations = new ArrayList<IMutation>(this.keys.size());
        for (Term key : this.keys) {
            rowMutations.add(this.mutationForKey(key.getByteBuffer(keyType, variables), keyspace, timestamp, clientState, variables, metadata));
        }
        return rowMutations;
    }

    public RowMutation mutationForKey(ByteBuffer key, String keyspace, Long timestamp, ThriftClientState clientState, List<ByteBuffer> variables, CFMetaData metadata) throws InvalidRequestException {
        RowMutation rm = new RowMutation(keyspace, key);
        QueryProcessor.validateKeyAlias(metadata, this.keyName);
        if (this.columns.size() < 1) {
            rm.delete(this.columnFamily, timestamp == null ? this.getTimestamp(clientState) : timestamp.longValue());
        } else {
            for (Term column : this.columns) {
                ByteBuffer columnName = column.getByteBuffer(metadata.comparator, variables);
                QueryProcessor.validateColumnName(columnName);
                rm.delete(this.columnFamily, columnName, timestamp == null ? this.getTimestamp(clientState) : timestamp.longValue());
            }
        }
        return rm;
    }

    public String toString() {
        return String.format("DeleteStatement(columns=%s, keyspace=%s, columnFamily=%s, consistency=%s keys=%s)", new Object[]{this.columns, this.keyspace, this.columnFamily, this.cLevel, this.keys});
    }
}

