/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cli;

import com.google.common.base.Joiner;
import com.netflix.astyanax.shaded.org.apache.cassandra.cli.CliSessionState;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.EncryptionOptions;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ITransportFactory;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CliOptions {
    private static final CLIOptions options = new CLIOptions();
    private static final String TOOL_NAME = "cassandra-cli";
    private static final String HOST_OPTION = "host";
    private static final String PORT_OPTION = "port";
    private static final String TRANSPORT_FACTORY = "transport-factory";
    private static final String DEBUG_OPTION = "debug";
    private static final String USERNAME_OPTION = "username";
    private static final String PASSWORD_OPTION = "password";
    private static final String KEYSPACE_OPTION = "keyspace";
    private static final String BATCH_OPTION = "batch";
    private static final String HELP_OPTION = "help";
    private static final String FILE_OPTION = "file";
    private static final String JMX_PORT_OPTION = "jmxport";
    private static final String JMX_USERNAME_OPTION = "jmxusername";
    private static final String JMX_PASSWORD_OPTION = "jmxpassword";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String SSL_TRUSTSTORE = "truststore";
    private static final String SSL_TRUSTSTORE_PW = "truststore-password";
    private static final String SSL_PROTOCOL = "ssl-protocol";
    private static final String SSL_ALGORITHM = "ssl-alg";
    private static final String SSL_STORE_TYPE = "store-type";
    private static final String SSL_CIPHER_SUITES = "ssl-ciphers";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_THRIFT_PORT = 9160;

    private static void printUsage() {
        new HelpFormatter().printHelp(TOOL_NAME, (Options)options);
    }

    public void processArgs(CliSessionState css, String[] args) {
        GnuParser parser = new GnuParser();
        try {
            CommandLine cmd = parser.parse((Options)options, args, false);
            css.hostName = cmd.hasOption(HOST_OPTION) ? cmd.getOptionValue(HOST_OPTION) : DEFAULT_HOST;
            if (cmd.hasOption(DEBUG_OPTION)) {
                css.debug = true;
            }
            css.thriftPort = cmd.hasOption(PORT_OPTION) ? Integer.parseInt(cmd.getOptionValue(PORT_OPTION)) : 9160;
            if (cmd.hasOption(USERNAME_OPTION)) {
                css.username = cmd.getOptionValue(USERNAME_OPTION);
            }
            if (cmd.hasOption(PASSWORD_OPTION)) {
                css.password = cmd.getOptionValue(PASSWORD_OPTION);
            }
            if (cmd.hasOption(KEYSPACE_OPTION)) {
                css.keyspace = cmd.getOptionValue(KEYSPACE_OPTION);
            }
            if (cmd.hasOption(BATCH_OPTION)) {
                css.batch = true;
            }
            if (cmd.hasOption(FILE_OPTION)) {
                css.filename = cmd.getOptionValue(FILE_OPTION);
            }
            if (cmd.hasOption(JMX_PORT_OPTION)) {
                css.jmxPort = Integer.parseInt(cmd.getOptionValue(JMX_PORT_OPTION));
            }
            if (cmd.hasOption(JMX_USERNAME_OPTION)) {
                css.jmxUsername = cmd.getOptionValue(JMX_USERNAME_OPTION);
            }
            if (cmd.hasOption(JMX_PASSWORD_OPTION)) {
                css.jmxPassword = cmd.getOptionValue(JMX_PASSWORD_OPTION);
            }
            if (cmd.hasOption(HELP_OPTION)) {
                CliOptions.printUsage();
                System.exit(1);
            }
            if (cmd.hasOption(VERBOSE_OPTION)) {
                css.verbose = true;
            }
            if (cmd.hasOption(SSL_TRUSTSTORE)) {
                css.encOptions.truststore = cmd.getOptionValue(SSL_TRUSTSTORE);
            }
            if (cmd.hasOption(SSL_TRUSTSTORE_PW)) {
                css.encOptions.truststore_password = cmd.getOptionValue(SSL_TRUSTSTORE_PW);
            }
            if (cmd.hasOption(SSL_PROTOCOL)) {
                css.encOptions.protocol = cmd.getOptionValue(SSL_PROTOCOL);
            }
            if (cmd.hasOption(SSL_ALGORITHM)) {
                css.encOptions.algorithm = cmd.getOptionValue(SSL_ALGORITHM);
            }
            if (cmd.hasOption(SSL_STORE_TYPE)) {
                css.encOptions.store_type = cmd.getOptionValue(SSL_STORE_TYPE);
            }
            if (cmd.hasOption(SSL_CIPHER_SUITES)) {
                css.encOptions.cipher_suites = cmd.getOptionValue(SSL_CIPHER_SUITES).split(",");
            }
            if (cmd.hasOption(TRANSPORT_FACTORY)) {
                css.transportFactory = CliOptions.validateAndSetTransportFactory(cmd.getOptionValue(TRANSPORT_FACTORY));
                CliOptions.configureTransportFactory(css.transportFactory, css.encOptions);
            }
            if (cmd.getArgs().length > 0) {
                System.err.printf("Unknown argument: %s%n", cmd.getArgs()[0]);
                System.err.println();
                CliOptions.printUsage();
                System.exit(1);
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.err.println();
            CliOptions.printUsage();
            System.exit(1);
        }
    }

    private static ITransportFactory validateAndSetTransportFactory(String transportFactory) {
        try {
            Class<?> factory = Class.forName(transportFactory);
            if (!ITransportFactory.class.isAssignableFrom(factory)) {
                throw new IllegalArgumentException(String.format("transport factory '%s' not derived from ITransportFactory", transportFactory));
            }
            return (ITransportFactory)factory.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot create a transport factory '%s'.", transportFactory), e);
        }
    }

    private static void configureTransportFactory(ITransportFactory transportFactory, EncryptionOptions encOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (transportFactory.supportedOptions().contains("enc.truststore")) {
            options.put("enc.truststore", encOptions.truststore);
        }
        if (transportFactory.supportedOptions().contains("enc.truststore.password")) {
            options.put("enc.truststore.password", encOptions.truststore_password);
        }
        if (transportFactory.supportedOptions().contains("enc.protocol")) {
            options.put("enc.protocol", encOptions.protocol);
        }
        if (transportFactory.supportedOptions().contains("enc.cipher.suites")) {
            options.put("enc.cipher.suites", Joiner.on((char)',').join((Object[])encOptions.cipher_suites));
        }
        if (transportFactory.supportedOptions().contains("enc.keystore") && encOptions.require_client_auth) {
            options.put("enc.keystore", encOptions.keystore);
        }
        if (transportFactory.supportedOptions().contains("enc.keystore.password") && encOptions.require_client_auth) {
            options.put("enc.keystore.password", encOptions.keystore_password);
        }
        for (String optionKey : transportFactory.supportedOptions()) {
            if (System.getProperty(optionKey) == null) continue;
            options.put(optionKey, System.getProperty(optionKey));
        }
        transportFactory.setOptions(options);
    }

    static {
        options.addOption("h", HOST_OPTION, "HOSTNAME", "cassandra server's host name");
        options.addOption("p", PORT_OPTION, "PORT", "cassandra server's thrift port");
        options.addOption("u", USERNAME_OPTION, "USERNAME", "user name for cassandra authentication");
        options.addOption("pw", PASSWORD_OPTION, "PASSWORD", "password for cassandra authentication");
        options.addOption("k", KEYSPACE_OPTION, "KEYSPACE", "cassandra keyspace user is authenticated against");
        options.addOption("f", FILE_OPTION, "FILENAME", "load statements from the specific file");
        options.addOption(null, JMX_PORT_OPTION, "JMX-PORT", "JMX service port");
        options.addOption(null, JMX_USERNAME_OPTION, "JMX-USERNAME", "JMX service username");
        options.addOption(null, JMX_PASSWORD_OPTION, "JMX-PASSWORD", "JMX service password");
        options.addOption("tf", TRANSPORT_FACTORY, "TRANSPORT-FACTORY", "Fully-qualified ITransportFactory class name for creating a connection to cassandra");
        options.addOption("ts", SSL_TRUSTSTORE, "TRUSTSTORE", "SSL: full path to truststore");
        options.addOption("tspw", SSL_TRUSTSTORE_PW, "TRUSTSTORE-PASSWORD", "SSL: password of the truststore");
        options.addOption("prtcl", SSL_PROTOCOL, "PROTOCOL", "SSL: connections protocol to use (default: TLS)");
        options.addOption("alg", SSL_ALGORITHM, "ALGORITHM", "SSL: algorithm (default: SunX509)");
        options.addOption("st", SSL_STORE_TYPE, "STORE-TYPE", "SSL: type of store");
        options.addOption("ciphers", SSL_CIPHER_SUITES, "CIPHER-SUITES", "SSL: comma-separated list of encryption suites to use");
        options.addOption("B", BATCH_OPTION, "enabled batch mode (suppress output; errors are fatal)");
        options.addOption(null, DEBUG_OPTION, "display stack-traces (NOTE: We print strack-traces in the places where it makes sense even without --debug)");
        options.addOption("?", HELP_OPTION, "usage help");
        options.addOption("v", VERBOSE_OPTION, "verbose output when using batch mode");
    }

    private static class CLIOptions
    extends Options {
        private CLIOptions() {
        }

        public Options addOption(String opt, String longOpt, String argName, String description) {
            Option option = new Option(opt, longOpt, true, description);
            option.setArgName(argName);
            return this.addOption(option);
        }

        public Options addOption(String opt, String longOpt, String description) {
            return this.addOption(new Option(opt, longOpt, false, description));
        }
    }
}

