/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cache;

import com.google.common.base.Objects;
import com.netflix.astyanax.shaded.org.apache.cassandra.cache.IRowCacheEntry;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ObjectSizes;
import java.util.concurrent.atomic.AtomicLong;

public class RowCacheSentinel
implements IRowCacheEntry {
    private static final AtomicLong generator = new AtomicLong();
    final long sentinelId;

    public RowCacheSentinel() {
        this.sentinelId = generator.getAndIncrement();
    }

    RowCacheSentinel(long sentinelId) {
        this.sentinelId = sentinelId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RowCacheSentinel)) {
            return false;
        }
        RowCacheSentinel other = (RowCacheSentinel)o;
        return this.sentinelId == other.sentinelId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sentinelId});
    }

    public long memorySize() {
        return ObjectSizes.getFieldSize(TypeSizes.NATIVE.sizeof(this.sentinelId));
    }
}

