/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cache;

import com.netflix.astyanax.shaded.org.apache.cassandra.cache.CacheKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.Descriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ObjectSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class KeyCacheKey
implements CacheKey {
    public final Descriptor desc;
    public final byte[] key;

    public KeyCacheKey(Descriptor desc, ByteBuffer key) {
        this.desc = desc;
        this.key = ByteBufferUtil.getArray(key);
        assert (this.key != null);
    }

    @Override
    public Pair<String, String> getPathInfo() {
        return Pair.create(this.desc.ksname, this.desc.cfname);
    }

    public String toString() {
        return String.format("KeyCacheKey(%s, %s)", this.desc, ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.key)));
    }

    @Override
    public long memorySize() {
        return ObjectSizes.getFieldSize(ObjectSizes.getReferenceSize() + ObjectSizes.getReferenceSize()) + ObjectSizes.getArraySize(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyCacheKey that = (KeyCacheKey)o;
        if (this.desc != null ? !this.desc.equals(that.desc) : that.desc != null) {
            return false;
        }
        return Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        int result = this.desc != null ? this.desc.hashCode() : 0;
        result = 31 * result + (this.key != null ? Arrays.hashCode(this.key) : 0);
        return result;
    }
}

