/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client;

import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.AbstractNacosRestTemplate;
import com.alibaba.nacos.common.http.client.handler.ResponseHandler;
import com.alibaba.nacos.common.http.client.request.AsyncHttpClientRequest;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RequestHttpEntity;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;

public class NacosAsyncRestTemplate
extends AbstractNacosRestTemplate {
    private final AsyncHttpClientRequest clientRequest;

    public NacosAsyncRestTemplate(Logger logger, AsyncHttpClientRequest clientRequest) {
        super(logger);
        this.clientRequest = clientRequest;
    }

    public <T> void get(String url, Header header, Query query, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "GET", new RequestHttpEntity(header, query), responseType, callback);
    }

    public <T> void get(String url, Header header, Map<String, String> paramValues, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "GET", new RequestHttpEntity(header, Query.newInstance().initParams(paramValues)), responseType, callback);
    }

    public <T> void getLarge(String url, Header header, Query query, Object body, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "GET-LARGE", new RequestHttpEntity(header, query, body), responseType, callback);
    }

    public <T> void delete(String url, Header header, Query query, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "DELETE", new RequestHttpEntity(header, query), responseType, callback);
    }

    public <T> void put(String url, Header header, Query query, Object body, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "PUT", new RequestHttpEntity(header, query, body), responseType, callback);
    }

    public <T> void putJson(String url, Header header, Map<String, String> paramValues, String body, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "PUT", new RequestHttpEntity(header.setContentType("application/json"), Query.newInstance().initParams(paramValues), body), responseType, callback);
    }

    public <T> void putForm(String url, Header header, Query query, Map<String, String> bodyValues, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "PUT", new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded"), query, bodyValues), responseType, callback);
    }

    public <T> void putForm(String url, Header header, Map<String, String> paramValues, Map<String, String> bodyValues, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "PUT", new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded"), Query.newInstance().initParams(paramValues), bodyValues), responseType, callback);
    }

    public <T> void post(String url, Header header, Query query, Object body, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "POST", new RequestHttpEntity(header, query, body), responseType, callback);
    }

    public <T> void postJson(String url, Header header, Map<String, String> paramValues, String body, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "POST", new RequestHttpEntity(header.setContentType("application/json"), Query.newInstance().initParams(paramValues), body), responseType, callback);
    }

    public <T> void postForm(String url, Header header, Query query, Map<String, String> bodyValues, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "POST", new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded"), query, bodyValues), responseType, callback);
    }

    public <T> void postForm(String url, Header header, Map<String, String> paramValues, Map<String, String> bodyValues, Type responseType, Callback<T> callback) throws Exception {
        this.execute(url, "POST", new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded"), Query.newInstance().initParams(paramValues), bodyValues), responseType, callback);
    }

    private <T> void execute(String url, String httpMethod, RequestHttpEntity requestEntity, Type type, Callback<T> callback) throws Exception {
        URI uri = HttpUtils.buildUri(url, requestEntity.getQuery());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("HTTP method: {}, url: {}, body: {}", new Object[]{httpMethod, uri, requestEntity.getBody()});
        }
        ResponseHandler responseHandler = super.selectResponseHandler(type);
        this.clientRequest.execute(uri, httpMethod, requestEntity, responseHandler, callback);
    }

    public void close() throws Exception {
        this.clientRequest.close();
    }
}

