package com.ptteng.wealth.util;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.admin.service.ConstantService;
import com.ptteng.wealth.finance.model.CreditApply;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.LoanApply;
import com.ptteng.wealth.finance.service.CreditApplyService;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.LoanApplyService;
import com.ptteng.wealth.finance.util.FinanceConstant;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.List;

/**
 * Created by asus on 2016/9/23.
 */
public class SmallLoanServiceImpl implements SmallLoanService {

    @Autowired
    public FundService fundService;
    @Autowired
    public ConstantService constantService;
    @Autowired
    public LoanApplyService loanApplyService;
    @Autowired
    public UserService userService;
    @Autowired
    public CreditApplyService creditApplyService;
    private Log b2bPayLog = LogFactory.getLog("b2b_pay");

    //第一次小额授权逻辑
    public Boolean smallLoanLineApply(Long uid) throws ServiceException, ServiceDaoException {
        Boolean result = false;
        String material = "";

        Fund fund = fundService.getObjectById(uid);
        User user = userService.getObjectById(uid);

        BigDecimal smallLoanLine = fund.getSmallLoanLine();
        b2bPayLog.info("user smallLoanLine : " + smallLoanLine);

        List<Long> smallLoanIdList = loanApplyService.getLoanApplyIdsByUidAndOrderType(uid, LoanApply.ORDER_TYPE_SMALL, 0, Integer.MAX_VALUE);
        b2bPayLog.info("user smallLoanIdList : " + smallLoanIdList);

        if (smallLoanLine.compareTo(new BigDecimal("0")) == 0 && smallLoanIdList.size() == 0) {
            b2bPayLog.info("user first use small loan ");

            String defaultLine = constantService.getValue("defaultLine", "smallLoan");
            b2bPayLog.info("user no smallLoanLine so update to : " + defaultLine);

            BigDecimal left = fund.getCreditLine().subtract(fund.getLoanNowTot());
            if (left.doubleValue() < 0) {
                left = new BigDecimal(0.0);
            }

            List<Long> creditAppliyIds = creditApplyService.getCreditApplyIdsByUid(uid, 0, 1);

            if (creditAppliyIds.size() == 0) {
                material = DebtConstant.Null_Material;
            } else {
                CreditApply creditApply = creditApplyService.getObjectById(creditAppliyIds.get(0));
                material = creditApply.getMaterial();
            }

            CreditApply creditApply = new CreditApply();
            creditApply.setUid(uid);
            creditApply.setOrgName(user.getName());
            creditApply.setName("");
            creditApply.setMobile(user.getMobile());
            creditApply.setLineBefore(fund.getCreditLine());
            creditApply.setLineLeft(left);
            creditApply.setSmallLineBefore(new BigDecimal("0"));
            creditApply.setSmallLineLeft(new BigDecimal("0"));
            creditApply.setSmallLineApply(new BigDecimal(defaultLine));
            creditApply.setSmallLineFinal(new BigDecimal(defaultLine));
            creditApply.setStatus(CreditApply.STATUS_PASS);
            creditApply.setMaterial(material);
            creditApply.setVerifyAt(System.currentTimeMillis());
            creditApply.setVerifyManager(-1L);//自动审核
            Long id = creditApplyService.insert(creditApply);
            creditApply.setId(id);
            b2bPayLog.info("SUCCESS: " + creditApply);

            fund.setSmallLoanLine(new BigDecimal(defaultLine));
            fundService.update(fund);

            b2bPayLog.info("update user smallLoanLine success");
            result = true;
        }
        return result;
    }

    //判断是否符合小额订单
    public Boolean check(Double price) throws ServiceException, ServiceDaoException {
        Boolean result = false;

        String begin = constantService.getValue("begin", "smallLoan");
        String end = constantService.getValue("end", "smallLoan");
        BigDecimal beginFee = new BigDecimal(begin);
        BigDecimal endFee = new BigDecimal(end);
        BigDecimal priceFee = new BigDecimal(price.toString());
        b2bPayLog.info("small loan range : " + beginFee + " to " + endFee + " , and totalFee : " + priceFee);

        if ("0".equals(end)) {
            b2bPayLog.info("endFee is 0 , so no check ,result is true ");
            result = true;
            return result;
        }

        Integer greater = priceFee.compareTo(beginFee);
        Integer less = priceFee.compareTo(endFee);

        if (greater == 1 && less == -1) {
            result = true;
        }

        b2bPayLog.info("check result : " + result);
        return result;
    }

    //信用小额判断用户小额额度是否足够
    public Integer smallLoanLineCheck(Double price, Long uid) throws ServiceException, ServiceDaoException {
        b2bPayLog.info("check user : " + uid + " small loan line about price : " + price);
        Integer result = 0;

        //剩余小额额度是否够
        Fund fund = fundService.getObjectById(uid);
        BigDecimal smallLoanLeft = fund.getSmallLoanLine().subtract(fund.getSmallLoanTot());
        BigDecimal priceFee = new BigDecimal(price.toString());
        Integer enough = smallLoanLeft.compareTo(priceFee);
        b2bPayLog.info("user small loan line left : " + smallLoanLeft + " , and totalFee : " + priceFee);
        if (enough == -1) {
            b2bPayLog.info("user small loan line left " + smallLoanLeft + " less than priceFee" + priceFee);
            result = 1;
        } else {
            //当日小额额度是否够
            String dailyLine = constantService.getValue("dailySmallLoanLine", "smallLoan");
            BigDecimal dailyLineFee = new BigDecimal(dailyLine);

            //上次小额时间日期结束时间
            Long time = MyTimeUtil.getEndTime(fund.getLastSmallLoan());
            b2bPayLog.info("user last small loan : " + fund.getLastSmallLoan());

            if (System.currentTimeMillis() > time) {
                fund.setTodaySmallLoan(new BigDecimal("0"));
                fundService.update(fund);
                b2bPayLog.info("last small loan more than one day to now ");
            }
            BigDecimal totalSpend = fund.getTodaySmallLoan().add(priceFee);
            Integer dailyEnough = dailyLineFee.compareTo(totalSpend);
            b2bPayLog.info("user daily small loan line : " + dailyLineFee + " , and total spend : " + totalSpend);
            if (dailyEnough == -1) {
                b2bPayLog.info("user daily small loan line " + dailyLineFee + " less total spend " + totalSpend);
                result = 2;
            }
        }

        if (result == 0) {
            b2bPayLog.info("small loan line check result : success !");
        } else if (result == 1) {
            b2bPayLog.info("small loan line check result : total small loan line not enough");
        } else if (result == 2) {
            b2bPayLog.info("small loan line check result : daily small loan line not enough");
        }

        return result;
    }

    //余额小额判断用户小额额度是否足够
    public Integer onlyDailySmallLoanLineCheck(Double price, Long uid) throws ServiceException, ServiceDaoException {
        b2bPayLog.info("check user : " + uid + " daily small loan line about price : " + price);
        Integer result = 0;
        Fund fund = fundService.getObjectById(uid);
        BigDecimal priceFee = new BigDecimal(price.toString());

        //当日小额额度是否够
        String dailyLine = constantService.getValue("dailySmallLoanLine", "smallLoan");
        BigDecimal dailyLineFee = new BigDecimal(dailyLine);

        //上次小额时间日期结束时间
        Long time = MyTimeUtil.getEndTime(fund.getLastSmallLoan());

        if (System.currentTimeMillis() > time) {
            fund.setTodaySmallLoan(new BigDecimal("0"));
            fundService.update(fund);
            b2bPayLog.info("last small loan more than one day to now ");
        }
        BigDecimal totalSpend = fund.getTodaySmallLoan().add(priceFee);
        Integer dailyEnough = dailyLineFee.compareTo(totalSpend);
        b2bPayLog.info("user daily small loan line : " + dailyLineFee + " , and total spend : " + totalSpend);
        if (dailyEnough == -1) {
            b2bPayLog.info("user daily small loan line " + dailyLineFee + " less total spend " + totalSpend);
            result = 2;
        }


        if (result == 0) {
            b2bPayLog.info("small loan line check result : success !");
        } else if (result == 2) {
            b2bPayLog.info("small loan line check result : daily small loan line not enough");
        }

        return result;
    }

    //判断是否自动审核
    public Boolean ifVerify(Double price) throws ServiceException, ServiceDaoException {
        Boolean result = false;

        String line = constantService.getValue("verifyLine", "smallLoan");

        BigDecimal lineFee = new BigDecimal(line);
        BigDecimal priceFee = new BigDecimal(price.toString());
        b2bPayLog.info("small loan verify line : " + line + " , and totalFee : " + priceFee);

        if ("0".equals(line)) {
            b2bPayLog.info("endFee is 0 , so no check ,result is true ");
            result = true;
            return result;
        }

        Integer verify = priceFee.compareTo(lineFee);

        if (verify == -1 || verify == 0) {
            result = true;
        }

        b2bPayLog.info("check result : " + result);
        return result;
    }
}
