package com.ptteng.wealth.util;

import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.consign.constant.FunctionConstants;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.*;
import com.ptteng.wealth.consign.model.out.TransactionRecordQueryOut;
import com.ptteng.wealth.finance.model.Product;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.util.Constant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by asus on 2016/11/29.
 */
public class ConsignConstructor {

    private static final Log log = LogFactory.getLog("invest");

    //查询证联余额入参构造
    public static BalanceInquiryIn balanceInquiryInConstructor(User user, Person person, Organization organization) {

        BalanceInquiryIn balanceInquiryIn = new BalanceInquiryIn();

        try {

            balanceInquiryIn.setBranchNo(GlobalConstant.BRANCH_NO);
            balanceInquiryIn.setFundAccount(user.getFundAccount());
            balanceInquiryIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            balanceInquiryIn.setUserId(user.getId() + "");
            if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                balanceInquiryIn.setCertType("0");
                balanceInquiryIn.setCertId(person.getIdNo());
                balanceInquiryIn.setUserNameText(user.getName());
            } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                balanceInquiryIn.setCertType(Constant.IDKIND);
                balanceInquiryIn.setUserNameText(organization.getName());
                balanceInquiryIn.setCertId(organization.getUseCertId());
            }
            balanceInquiryIn.setPassword(user.getPayPwd());
            balanceInquiryIn.setGtTradePassword(user.getPayPwd());
            balanceInquiryIn.setIfQueryTransitmAmt("1");

        } catch (Exception var3) {
            var3.printStackTrace(System.out);
        }

        return balanceInquiryIn;
    }

    //查询银行卡列表入参构造
    public static  BindingBankIn bindingBankInConstructor(User user) {

        BindingBankIn bindingBankIn = new BindingBankIn();

        try {
            bindingBankIn.setUserId(user.getId().toString());
            bindingBankIn.setFundAccount(user.getFundAccount());
            bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);

        } catch (Exception var3) {
            var3.printStackTrace(System.out);
        }

        return bindingBankIn;
    }


    public static  FundBuyIn fundBuyInConstructor(User user, Product product, BigDecimal investment, String cardNo, String bankName) {

        FundBuyIn fundBuyIn = new FundBuyIn();

        try {

            fundBuyIn.setFunctionId(FunctionConstants.buyFund);
            fundBuyIn.setUserId(user.getId() + "");
            fundBuyIn.setBranchNo(GlobalConstant.BRANCH_NO);
            fundBuyIn.setFundAccount(user.getFundAccount());
            fundBuyIn.setPassword(user.getPayPwd());
            fundBuyIn.setFundCode(product.getProductNo());
            fundBuyIn.setFundCompany(product.getCompanyNo());
            fundBuyIn.setBankBalance(investment);
            fundBuyIn.setAmountT(investment);
            fundBuyIn.setBankNo(bankName);
            fundBuyIn.setBankAccount(cardNo);
            fundBuyIn.setOutterSerialNo(System.currentTimeMillis() + "");
            fundBuyIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());

        } catch (Exception var3) {
            var3.printStackTrace(System.out);
        }

        return fundBuyIn;
    }

    public static CurrentPositionStatIn currentPositionStatInConstructor(User user, Product product) {

        CurrentPositionStatIn in = new CurrentPositionStatIn();

        try {

            in.setBranchNo(GlobalConstant.BRANCH_NO);
            in.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            in.setFunctionId(FunctionConstants.getCurrentIncomeRecordCount);
            in.setFundAccount(user.getFundAccount());
            in.setUserId(user.getId() + "");
            in.setCashFundCompany(product.getCompanyNo());
            in.setCashFundCode(product.getProductNo());

        } catch (Exception var3) {
            var3.printStackTrace(System.out);
        }

        return in;
    }

    public static CurrentIncomeRecordIn recordInConstructor(User user, Product product) {

        CurrentIncomeRecordIn recordIn = new CurrentIncomeRecordIn();

        try {

            recordIn.setCashFundCompany(product.getCompanyNo());
            recordIn.setCashFundCode(product.getProductNo());
            recordIn.setBranchNo(GlobalConstant.BRANCH_NO);
            recordIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            recordIn.setFunctionId(FunctionConstants.getCurrentIncomeRecordCount);
            recordIn.setFundAccount(user.getFundAccount());
            recordIn.setUserId(user.getId() + "");
            recordIn.setStartDate(getDate(-1));
            recordIn.setEndDate(getDate(-1));

        } catch (Exception var3) {
            var3.printStackTrace(System.out);
        }

        return recordIn;

    }

    public static TransactionRecordQueryIn trqiConstructor(User user, Product product, String businessFlag, Integer page, Integer size) {

        TransactionRecordQueryIn trqi = new TransactionRecordQueryIn();

        try {

            trqi.setFunctionId(FunctionConstants.queryRecord);
            trqi.setUserId(user.getId() + "");
            trqi.setBranchNo(GlobalConstant.BRANCH_NO);
            trqi.setFundAccount(user.getFundAccount());
            trqi.setPageNo(page);
            trqi.setBusinessFlag(businessFlag);
            trqi.setRequestNum(size);
            trqi.setFundCode(product.getProductNo());
            trqi.setmEntrustStatus("!");
            trqi.setmStockType("y");
            trqi.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            trqi.setBeginDate(20130101);
            trqi.setEndDate(getDate(0));

        } catch (Exception var3) {
            var3.printStackTrace(System.out);
        }

        return trqi;
    }

    public static TransactionRecordCountIn countInConstructor(User user, Product product, String businessFlag) {

        TransactionRecordCountIn countIn = new TransactionRecordCountIn();

        try {
            countIn.setFunctionId(FunctionConstants.queryRecord);
            countIn.setUserId(user.getId() + "");
            countIn.setBranchNo(GlobalConstant.BRANCH_NO);
            countIn.setFundAccount(user.getFundAccount());
            countIn.setBusinessFlag(businessFlag);
            countIn.setFundCode(product.getProductNo());
            countIn.setmEntrustStatus("!");
            countIn.setmStockType("y");
            countIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            countIn.setBeginDate(20130101);
            countIn.setEndDate(getDate(0));

        } catch (Exception var3) {
            var3.printStackTrace(System.out);
        }
        return countIn;
    }


    public static Map<Integer, String> dateFormate(List<TransactionRecordQueryOut> recordQueryOuts) {

        Map<Integer, String> date = new HashMap<>();

        try {

            for (TransactionRecordQueryOut record : recordQueryOuts) {
                String initDate = record.getCurrDate() + "";
                String initDateShow = initDate.substring(0, 4) + "-" + initDate.substring(4, 6) + "-" + initDate.substring(6, initDate.length());
                date.put(record.getCurrDate(), initDateShow);
            }

        } catch (Exception var3) {
            var3.printStackTrace(System.out);
        }

        return date;
    }



    public static Integer getDate(int day) {
        Date date = new Date(System.currentTimeMillis() + day * DebtConstant.DAILY_TIME);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String updateTime = dateFormat.format(date);
        Integer result = Integer.valueOf(updateTime);
        return result;
    }

}
