package com.ptteng.wealth.user.controller;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.*;
import com.gemantic.common.util.http.cookie.MD5Util;

import com.gemantic.common.util.http.cookie.XBase64;
import com.ptteng.common.storage.util.CaptchaUtil;

import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.common.model.Sms;
import com.ptteng.wealth.common.service.SmsService;
import com.ptteng.wealth.consign.constant.FunctionConstants;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.*;
import com.ptteng.wealth.consign.model.out.*;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.finance.model.DebtApply;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.LoanApply;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.user.model.*;
import com.ptteng.wealth.user.model.work.CardModel;
import com.ptteng.wealth.user.service.OrganizationService;
import com.ptteng.wealth.user.service.PersonService;
import com.ptteng.wealth.user.service.UserOpenidRelationService;

import com.ptteng.wealth.user.util.Constant;
import com.ptteng.wealth.user.util.InterfaceCodeConstant;
import com.ptteng.wealth.util.DebtConstant;
import com.ptteng.wealth.util.JinShenUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.IdentityUtil;
import com.qding.common.util.http.cookie.RequestUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.user.service.UserService;
import com.ptteng.wealth.consign.model.*;

import static java.lang.Math.ceil;

/**
 * User crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserController extends BaseController {
    private static final Log log = LogFactory.getLog(UserController.class);
    private static final Log b2bfundLog = LogFactory.getLog("b2bfundLog");
    private static final Log fundLog = LogFactory.getLog("fundlog");
    private static final Log resetPassLog = LogFactory.getLog("reset_pwd_log");
    private static final Log changePassLog = LogFactory.getLog("change_pwd_log");

    @Autowired
    private UserService userService;

    @Autowired
    private OrganizationService organizationService;

    @Autowired
    private PersonService personService;

    @Autowired
    private FundService fundService;

    @Autowired
    private UserAccountRelationService userAccountRelationService;

    @Autowired
    private ConsignmentService consignmentService;

    @Autowired
    private UserOpenidRelationService userOpenidRelationService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private AccountService accountService;

    @Autowired
    private SmsService smsService;

    private boolean isCaptcha = false;

    private String CAPTCHA = "captch";

    @RequestMapping(value = "/a/wrong")
    public String noLogin(HttpServletRequest request,
                          HttpServletResponse response, ModelMap model, Integer page,
                          Integer size) throws Exception {
        log.info(" login wrong ");
        cookieUtil.clearCookie(response);
        model.addAttribute("code", -2);
        return "/data/json";
    }

    // 是否有发送验证码

    // 验证码校验
    private boolean verifyMobileCode(ModelMap model, String mobile, String type, String verify) throws ServiceException, ServiceDaoException {
        log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
        log.info("sid is " + sid);

        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        log.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        log.info("message is " + message);

        // 发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();

        if (delay > 600000) {
            model.addAttribute("code", -1005);
            log.info("require verify too long");
            return false;
        }

        if (message.equals(verify)) {
            return true;
        } else {
            return false;
        }

    }

    // 4、验证码发送
    @RequestMapping(value = "/a/user/send", method = RequestMethod.POST)
    public String sendVerify(ModelMap model, String mobile, String type,
                             Integer accountType) throws ServiceException, ServiceDaoException {
        log.info(mobile + " want send sms of type " + type);
        if (StringUtils.isBlank(mobile)) {
            log.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", InterfaceCodeConstant.Mobile_Null);
            return "/common/success";
        }
        if (StringUtils.isBlank(type)) {
            type = "password";
        }
        Long relationID = null;
        boolean alreadyRegedit = false;
        if (User.TYPE_PERSON.equals(accountType)) {
            relationID = this.userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Person_Mobile);

        } else {
            relationID = this.userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Org_Mobile);

        }
        if (null != relationID) {
            alreadyRegedit = true;
        }
        if ("register".equals(type)) {
            //注册的时候判断手机是否已经注册过了
            if (alreadyRegedit) {
                log.info(type + " is already exist  " + mobile);
                model.addAttribute("code", InterfaceCodeConstant.Mobile_AlreadyExist);
                return "/common/success";
            }
        }
        int code = InterfaceCodeConstant.System_Success;
        try {
            log.info(" USER: SENDMessage: mobile: " + mobile + " type: " + type);
            if (null == smsService) {
                log.info(" smsService is null ");
            }
            String result = this.smsService.sendMsg(mobile, type);
            log.info(" USER: SENDMessage: RESULT: " + result);
            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = InterfaceCodeConstant.VerifyCode_Type_NotSupport;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = InterfaceCodeConstant.VerifyCode_MoreThan5;
                    break;
                default:
            }
            model.addAttribute("code", code);
        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(mobile + " send message error of type " + type);
            model.addAttribute("code", InterfaceCodeConstant.System_Exception);
        }
        return "/common/success";
    }


    // 5、忘记密码 (重置密码)
    @RequestMapping(value = "/a/{accountType}/forget/password/{pwdType}", method = RequestMethod.PUT)
    public String rewritepwd(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile,
                             String verify, String newpwd, @PathVariable String pwdType,
                             @PathVariable String accountType) throws Exception {
        int code = 0;
        try {
            resetPassLog.info("====================================================================");
            resetPassLog.info(mobile + " verify: " + verify + " set new pwd " + newpwd + " type is " + pwdType + " accountType " + accountType);
            // 是否已注册
            Long relationID = null;
            if ("user".equals(accountType)) {
                relationID = this.userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Person_Mobile);

            } else {
                relationID = this.userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Org_Mobile);
            }
            // 用户不存在
            if (relationID == null) {
                resetPassLog.info(mobile + " not exist ");
                code = InterfaceCodeConstant.User_NotExist;
            } else {
                UserOpenidRelation relation = userOpenidRelationService.getObjectById(relationID);
                Long uid = relation.getTypeId();
                resetPassLog.info(mobile + " exist and uid is " + relation.getTypeId());
                String verifyType = "password";
                boolean result = false;
                if ("666666".equals(verify)) {
                    result = true;
                } else {
                    result = verifyMobileCode(model, mobile, verifyType, verify);
                }
//                result = verifyMobileCode(model, mobile, verifyType, verify);
                resetPassLog.info(mobile + " verify : " + result);
                // verifyResult = true;
                User user = userService.getObjectById(uid);
                if (result) {
                    //重置交易密码
                    if ("trade".equals(pwdType)) {
                        if (user.getPwd().equals(PasswordUtils.encode(newpwd))) {
                            code = -2018;
                        } else {
                            try {
                                RetrieveTransactionPasswordIn retrieveTransactionPasswordIn = new RetrieveTransactionPasswordIn();
                                retrieveTransactionPasswordIn.setUserId(uid.toString());
                                retrieveTransactionPasswordIn.setFundAccount(user.getFundAccount());
                                retrieveTransactionPasswordIn.setNewPassword(newpwd);
                                CommonOut commonOut = consignmentService.retrieveTransactionPassword(retrieveTransactionPasswordIn);
                                if (0 == commonOut.getErrorNo()) {
                                    resetPassLog.info(mobile + " : RESET PAY PASSWORD : " + newpwd + " SUCCESS");
                                }
                            } catch (Exception e) {
                                e.printStackTrace(System.out);
                                resetPassLog.error(e.getMessage());
                            }
                            user.setPayPwd(newpwd);
                            userService.update(user);
                            resetPassLog.info(mobile + " : RESET PAY PASSWORD : " + newpwd);
                        }

                    }
                    //重置登陆密码,适用于用户的激活流程
                    else {
                        if (newpwd.equals(user.getPayPwd())) {
                            code = -2018;
                        } else {
                            user.setStatus(User.USER_ACTIVIATE);
                            user.setPwd(PasswordUtils.encode(newpwd));
                            userService.update(user);
                            resetPassLog.info(mobile + " : RESET  PASSWORD : " + newpwd);
                        }

                    }
                } else {
                    code = InterfaceCodeConstant.VerifyCode_Error;
                }
            }

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            log.error(t.getMessage());
            log.error("add user error ");
            code = -1;
        }
        model.addAttribute("code", code);
        return "/common/success";

    }


    // 6、退出登录
    @RequestMapping(value = "/a/logout", method = RequestMethod.POST)
    public String logout(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        log.info(" welcome to manager logout ");
        try {
            cookieUtil.clearCookie(response);
            model.addAttribute("code", 0);
            return "/common/success";
        } catch (Throwable t) {
            model.addAttribute("code", 2006);
            log.error("user logout error  ");
            t.printStackTrace();
            return "/common/success";
        }
    }

    // 7、本人信息读取
    @RequestMapping(value = "/a/u/user/self", method = RequestMethod.GET)
    public String getUserJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model) throws Exception {

        log.info(" ===================================================== ");

        try {
            Long uid = cookieUtil.getID(request);
            log.info("get user detail : " + uid);
            User user = userService.getObjectById(uid);
            Organization organization = organizationService.getObjectById(uid);
            Person person = personService.getObjectById(uid);
            if (user.getType().equals(User.TYPE_PERSON)) {
                Long personApplyId = personApplyService.getPersonApplyIdByUid(user.getId());
                if (null != personApplyId) {
                    PersonApply personApply = personApplyService.getObjectById(personApplyId);
                    user.setAuthStatus(personApply.getStatus());
                } else {
                    user.setAuthStatus(PersonApply.STATUS_4);
                }
                person = personService.getObjectById(user.getId());
            }
            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("org", organization);
            model.addAttribute("person", person);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get user error");
            model.addAttribute("code", -1);
        }

        return "/wealth-user-service/user/json/userDetailJson";
    }

    // 8、本人信息读取
    @RequestMapping(value = "/a/u/user/userinfos", method = RequestMethod.GET)
    public String getUserInfo(HttpServletRequest request, ModelMap model) throws Exception {
        Person person = new Person();
        Organization organization = new Organization();
        try {
            Long uid = cookieUtil.getID(request);
            log.info("user id : " + uid);
            User user = userService.getObjectById(uid);

//            Organization organization = organizationService.getObjectById(uid);
            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            model.addAttribute("org", organization);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get user error");
            model.addAttribute("code", -1);
        }

        return "/wealth-user-service/user/json/userDetailJson";
    }


    // 8、本人资金信息读取
    @RequestMapping(value = "/a/u/user/fund")
    public String getUserFund(HttpServletRequest request, ModelMap model) throws Exception {
        fundLog.info("\n /a/user/fund =================================================");


        Long uid = 0l;
        //第一步： 获取用户信息
        uid = getUserId(request);
        User user = userService.getObjectById(uid);
        fundLog.info("S1 userid: " + uid);
        if (null == uid) {
            model.addAttribute("code", -2000);
            fundLog.info(" userid : " + uid + " not exist");
            return "/common/success";
        }
        try {
            Fund fund = fundService.getObjectById(uid);
            BigDecimal totalRepay = caculateRepayTotal(uid);
            fundLog.info("totalRepay is : " + totalRepay);
            fund.setRepayTot(totalRepay);
            fundService.update(fund);

            List<UserAccountRelation> relations = new ArrayList<UserAccountRelation>();
            if (null != relations) {
                List<Long> relationIds = userAccountRelationService.getUserAccountRelationIdsByUserId(uid, 0, Integer.MAX_VALUE);
                relations = userAccountRelationService.getObjectsByIds(relationIds);
            }
            BalanceInquiryOut balance = null;

            try {
                BalanceInquiryIn balanceInquiryIn = new BalanceInquiryIn();
                balanceInquiryIn.setBranchNo(GlobalConstant.BRANCH_NO);
                balanceInquiryIn.setFundAccount(user.getFundAccount());
                balanceInquiryIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                balanceInquiryIn.setUserId(user.getId() + "");
                if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                    Person person = personService.getObjectById(user.getId());
                    balanceInquiryIn.setCertType("0");
                    balanceInquiryIn.setCertId(person.getIdNo());
                    balanceInquiryIn.setUserNameText(user.getName());
                } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                    Organization organization = organizationService.getObjectById(user.getId());
                    balanceInquiryIn.setCertType(Constant.IDKIND);
                    balanceInquiryIn.setUserNameText(organization.getName());
                    balanceInquiryIn.setCertId(organization.getUseCertId());
                }
                balanceInquiryIn.setPassword(user.getPayPwd());
                balanceInquiryIn.setGtTradePassword(user.getPayPwd());
                balanceInquiryIn.setIfQueryTransitmAmt("1");
                balance = consignmentService.getBalance(balanceInquiryIn);
                fundLog.info(balance);
            } catch (Exception e) {
                fundLog.info(e.getMessage());
            }

            //借款总额
            BigDecimal totalLoanMoney = new BigDecimal("0");
            List<Long> idLs = loanApplyService.getLoanApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
            fundLog.info(" idLs size : " + idLs.size());
            List<LoanApply> loanApplies = loanApplyService.getObjectsByIds(idLs);
            for (LoanApply loanApply : loanApplies) {
                if (loanApply.getStatus().equals(LoanApply.STATUS_CLEAR) || loanApply.getStatus().equals(LoanApply.STATUS_REFUSE)
                        || loanApply.getStatus().equals(LoanApply.STATUS_KAILIN_REFUSE) || loanApply.getStatus().equals(LoanApply.STATUS_CANCEL)) {
                    continue;
                }
                totalLoanMoney = totalLoanMoney.add(loanApply.getDebtCount());
            }
            fundLog.info("totalLoanMoney : " + totalLoanMoney);
            BigDecimal debtTot = totalLoanMoney.add(fund.getLoanNowTot());
            fundLog.info("debtTot : " + debtTot);
            BigDecimal availableLine = fund.getCreditLine().subtract(debtTot);
            Integer zeroVerify = availableLine.compareTo(new BigDecimal("0"));
            if (-1 == zeroVerify) {
                availableLine = new BigDecimal("0");
            }
            fundLog.info("availableLine : " + availableLine);

            //证联余额
            BigDecimal balanceFee = new BigDecimal("0");
            if (null != balance && 0 == balance.getErrorNo()) {
                model.addAttribute("wayFund", balance.getRedeeTransitmAmt());
                model.addAttribute("balance", balance.getTotalAmt());
                balanceFee = balance.getTotalAmt();
            } else {
                model.addAttribute("wayFund", 0);
                model.addAttribute("balance", 0);
            }

            //资产总额
            BigDecimal fundTot = balanceFee;
            for (UserAccountRelation userAccountRelation : relations) {
                fundTot = fundTot.add(userAccountRelation.getMoney());
            }
            fundLog.info("fundTot : " + fundTot);

            model.addAttribute("code", 0);
            model.addAttribute("fund", fund);
            model.addAttribute("relations", relations);
            model.addAttribute("fundTot", fundTot);
            model.addAttribute("debtTot", debtTot);
            model.addAttribute("availableLine", availableLine);

        } catch (Throwable t) {
            fundLog.error(t.getMessage());
            fundLog.error("get user error");
            model.addAttribute("code", -1);
        }
        return "/wealth-user-service/user/json/userFundDetail";
    }

    //原b2b使用接口，已替换
    @RequestMapping(value = "/a/user/fund")
    public String getUserAFund(HttpServletRequest request, HttpServletResponse response, ModelMap model, String token) throws Exception {
        fundLog.info("\n /a/user/fund =================================================");
        Long uid = 0l;
        //第一步： 获取用户信息
        fundLog.info(" S1 token : " + token);
        if (StringUtils.isNotBlank(token)) {
            uid = Long.parseLong(JinShenUtil.parseToken(token));
            fundLog.info("S1 token: user id : " + uid);
        } else {
            uid = cookieUtil.getID(request);
        }
        User user = userService.getObjectById(uid);
        fundLog.info("S1 userid: " + uid);
        if (null == uid) {
            model.addAttribute("code", -2000);
            fundLog.info(" userid : " + uid + " not exist");
            return "/common/success";
        }
        try {
            Fund fund = fundService.getObjectById(uid);
            List<UserAccountRelation> relations = new ArrayList<UserAccountRelation>();
            if (null != relations) {
                List<Long> relationIds = userAccountRelationService.getUserAccountRelationIdsByUserId(uid, 0, Integer.MAX_VALUE);
                relations = userAccountRelationService.getObjectsByIds(relationIds);
            }
            BalanceInquiryOut balance = null;

            try {
                BalanceInquiryIn balanceInquiryIn = new BalanceInquiryIn();
                balanceInquiryIn.setBranchNo(GlobalConstant.BRANCH_NO);
                balanceInquiryIn.setFundAccount(user.getFundAccount());
                balanceInquiryIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                balanceInquiryIn.setUserId(user.getId() + "");
                if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                    Person person = personService.getObjectById(user.getId());
                    balanceInquiryIn.setCertType("0");
                    balanceInquiryIn.setCertId(person.getIdNo());
                    balanceInquiryIn.setUserNameText(user.getName());
                } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                    Organization organization = organizationService.getObjectById(user.getId());
                    balanceInquiryIn.setCertType(Constant.IDKIND);
                    balanceInquiryIn.setUserNameText(organization.getName());
                    balanceInquiryIn.setCertId(organization.getUseCertId());
                }
                balanceInquiryIn.setPassword(user.getPayPwd());
                balanceInquiryIn.setGtTradePassword(user.getPayPwd());
                balanceInquiryIn.setIfQueryTransitmAmt("1");
                balance = consignmentService.getBalance(balanceInquiryIn);
                fundLog.info(balance);
            } catch (Exception e) {
                fundLog.info(e.getMessage());
            }
            if (null != balance) {
                model.addAttribute("wayFund", balance.getRedeeTransitmAmt());
                model.addAttribute("balance", balance.getTotalAmt());
            } else {
                model.addAttribute("wayFund", 0);
                model.addAttribute("balance", 0);
            }
            model.addAttribute("code", 0);
            model.addAttribute("fund", fund);
            model.addAttribute("relations", relations);
        } catch (Throwable t) {
            fundLog.error(t.getMessage());
            fundLog.error("get user error");
            model.addAttribute("code", -1);
        }
        return "/wealth-user-service/user/json/userFundDetail";
    }

    // 8、B2B资金信息读取
    @RequestMapping(value = "/bpay/account")
    public String b2bFund(ModelMap model, String token) throws Exception {
        HashMap<String, BigDecimal> accountName_money = new HashMap<>();
        List<String> names = new ArrayList<>();
        String name = "";
        b2bfundLog.info("===================================================== ");
        b2bfundLog.info("token is : " + token);
        token = XBase64.deReplace(token);
        b2bfundLog.info("new token is " + token);
        String userKailinCode = DESUtil.decrypt(token.getBytes());

        b2bfundLog.info("kailinCode : " + userKailinCode);
        Long uid = userService.getUserIdByKailinCode(userKailinCode);
        if (null == uid) {
            model.addAttribute("code", -2000);
            b2bfundLog.info(" FAIL: userid : " + uid + " not exist");
            return "/common/success";
        }
        try {
            b2bfundLog.info(" 1 userservice here");
            User user = userService.getObjectById(uid);
            b2bfundLog.info(" 2  fundservice here ");
            Fund fund = fundService.getObjectById(uid);
            b2bfundLog.info(" 3 fund:  " + fund);
            List<UserAccountRelation> relations = new ArrayList<UserAccountRelation>();
            if (null != relations) {
                b2bfundLog.info(" 4 relation  size :  " + relations.size());
                List<Long> acountIds = accountService.getAccountIds(0, Integer.MAX_VALUE);
                List<Account> accountList = accountService.getObjectsByIds(acountIds);
                List<Long> relationIds = userAccountRelationService.getUserAccountRelationIdsByUserId(uid, 0, Integer.MAX_VALUE);
                relations = userAccountRelationService.getObjectsByIds(relationIds);
                for (Account account : accountList) {
                    for (UserAccountRelation relation : relations) {
                        if (account.getId().equals(relation.getAccountId())) {
                            names.add(account.getName());
                            accountName_money.put(account.getName(), relation.getMoney());
                            break;
                        }
                    }
                    if (null == accountName_money.get(account.getName())) {
                        names.add(account.getName());
                        accountName_money.put(account.getName(), new BigDecimal("0"));
                    }
                }
            }

            BalanceInquiryOut balance = new BalanceInquiryOut();
            balance.setTotalAmt(new BigDecimal("0"));
            balance.setTransAmt(new BigDecimal("0"));

            if (User.VERIFY_YES.equals(user.getVerifyStatus())) {
                try {
                    b2bfundLog.info(" 5 begin consign   ");
                    BalanceInquiryIn balanceInquiryIn = new BalanceInquiryIn();
                    balanceInquiryIn.setBranchNo(GlobalConstant.BRANCH_NO);
                    balanceInquiryIn.setFundAccount(user.getFundAccount());
                    balanceInquiryIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                    balanceInquiryIn.setUserId(user.getId() + "");
                    if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                        b2bfundLog.info("personal user");
                        Person person = personService.getObjectById(user.getId());
                        b2bfundLog.info("person : " + person);
                        balanceInquiryIn.setCertType("0");
                        balanceInquiryIn.setCertId(person.getIdNo());
                        balanceInquiryIn.setUserNameText(user.getName());
                    } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                        b2bfundLog.info("organization user");
                        Organization organization = organizationService.getObjectById(user.getId());
                        b2bfundLog.info("organization : " + organization);
                        balanceInquiryIn.setCertType(Constant.IDKIND);
                        balanceInquiryIn.setUserNameText(organization.getName());
                        balanceInquiryIn.setCertId(organization.getUseCertId());
                    }
                    balanceInquiryIn.setPassword(user.getPayPwd());
                    balanceInquiryIn.setGtTradePassword(user.getPayPwd());
                    balance = consignmentService.getBalance(balanceInquiryIn);
                    b2bfundLog.info(balance);
                    b2bfundLog.info(" 6 begin consign   " + balance);
                    if (null == balance.getTotalAmt()) {
                        b2bfundLog.info("no balance!");
                        balance.setTotalAmt(new BigDecimal("0"));
                    }
                } catch (Exception e) {
                    b2bfundLog.info(e.getMessage());
                }
            }


            BigDecimal totalLoanMoney = new BigDecimal("0");
            List<Long> idLs = loanApplyService.getLoanApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
            List<LoanApply> loanApplies = loanApplyService.getObjectsByIds(idLs);
            for (LoanApply loanApply : loanApplies) {
                if (loanApply.getStatus().equals(LoanApply.STATUS_CLEAR) || loanApply.getStatus().equals(LoanApply.STATUS_REFUSE)
                        || loanApply.getStatus().equals(LoanApply.STATUS_KAILIN_REFUSE) || loanApply.getStatus().equals(LoanApply.STATUS_CANCEL)) {
                    continue;
                }
                totalLoanMoney = totalLoanMoney.add(loanApply.getDebtCount());
            }

            BigDecimal useFund = fund.getCreditLine().subtract(fund.getLoanNowTot()).subtract(totalLoanMoney);


            model.addAttribute("code", 0);
            model.addAttribute("fund", fund);
            model.addAttribute("names", names);
            model.addAttribute("accountName_money", accountName_money);
            model.addAttribute("wayFund", balance.getTransAmt());
            model.addAttribute("balance", balance.getTotalAmt());
            model.addAttribute("debt", verifyNum(totalLoanMoney));
            model.addAttribute("useFund", verifyNum(useFund));
        } catch (Throwable t) {
            b2bfundLog.error(t.getMessage());
            b2bfundLog.error("get user error");
            model.addAttribute("code", -1);
        }

        return "/wealth-user-service/user/json/b2bFundJson";
    }

    public BigDecimal verifyNum(BigDecimal num){
        if(null == num){
            return null;
        }else {
            BigDecimal zero = new BigDecimal("0");
            Integer result = num.compareTo(zero);
            if (result == -1) {
                num = new BigDecimal("0");
            }else {
                b2bfundLog.info("num " + num + " bigger than zero");
            }
        }
        return num;
    }

    // 9、修改密码
    @RequestMapping(value = "/a/u/user/password/{type}", method = RequestMethod.PUT)
    public String editPassword(HttpServletRequest request, HttpServletResponse response, ModelMap model, String oldPasword, String newPasword, @PathVariable String type) throws Exception {
        int code = 0;
        try {
            Long uid = cookieUtil.getID(request);
            User user = userService.getObjectById(uid);
            String encodePwd = PasswordUtils.encode(oldPasword);
            String encodeNewPwd = PasswordUtils.encode(newPasword);
            changePassLog.info("=========================================================");
            changePassLog.info("get person " + uid);
            changePassLog.info("user   " + user);
            if (null == newPasword) {
                changePassLog.info("newPassword is null");
                code = -2005;
            } else {
                //修改交易密码
                if ("trade".equals(type)) {
                    if (user.getPwd().equals(encodeNewPwd)) {
                        code = -2018;
                    } else {
                        if (!user.getPayPwd().equals(oldPasword)) {
                            code = -2004;
                        } else {
                            if (null != user.getFundAccount()) {
                                TransactionPasswordIn transactionPasswordIn = new TransactionPasswordIn();
                                transactionPasswordIn.setPassword(oldPasword);
                                transactionPasswordIn.setNewPassword(newPasword);
                                transactionPasswordIn.setUserId(uid.toString());
                                transactionPasswordIn.setFundAccount(user.getFundAccount());
                                CommonOut commonOut = consignmentService.modifyTransactionPassword(transactionPasswordIn);
                                if (0 == commonOut.getErrorNo()) {
                                    changePassLog.info(" commontOut : " + commonOut.getErrorInfo());
                                }
                            }
                            user.setPayPwd(newPasword);
                            userService.update(user);
                            changePassLog.info(" update  pay password success ");
                        }

                    }
                } else {
                    if (newPasword.equals(user.getPayPwd())) {
                        code = -2018;
                    } else {
                        if (encodePwd.equals(user.getPwd())) {
                            user.setPwd(encodeNewPwd);
                            userService.update(user);
                            changePassLog.info("update password success, new password is " + newPasword);
                        } else {
                            code = -2004;
                            changePassLog.info("wrong password");
                        }
                    }

                }
            }


        } catch (Throwable t) {
            changePassLog.error(t.getMessage());
            changePassLog.error("update password error,pwd is  " + oldPasword);
            code = -1;
        }
        model.addAttribute("code", code);
        return "/common/success";
    }

    /**
     * 10、修改用户手机号 (组织机构和个人)
     */
    @RequestMapping(value = "/a/u/user/mobile/{type}", method = RequestMethod.PUT)
    public String updateMoblie(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, String newMobile,
                               String verify, @PathVariable String type) {

        try {
            Long uid = cookieUtil.getID(request);
            if (null == uid) {
                log.info("no uid");
                model.addAttribute("code", -2000);
                return "/common/success";
            }
            User user = userService.getObjectById(uid);
            if (null == user) {
                log.info("user is null");
                model.addAttribute("code", -2000);
                return "/common/success";
            }
            Long userId = userService.getUserIdByMobile(newMobile);
            if (null != userId) {
                log.info("mobile is exist");
                model.addAttribute("code", -9000);
                return "/common/success";
            }
            boolean verifyResult = false;

            String verifyType = "register";
            log.info("log1: mobile is " + newMobile + ",type = " + verifyType
                    + ",verify =" + verify);
            verifyResult = verifyMobileCode(model, newMobile, verifyType,
                    verify);

            if ("666666".equals(verify) || verifyResult) {

                if (Constant.Person_type.equals(type)) {
                    Long userOpenidRelationId = userOpenidRelationService
                            .getUserOpenidRelationIdByOpenidAndStatus(
                                    user.getMobile(), type);
                    if (null == userOpenidRelationId) {
                        log.info("userOpenidRelationId is not exist");
                        model.addAttribute("code", -2000);
                        return "/common/success";
                    }
                    UserOpenidRelation userOpenidRelation = userOpenidRelationService
                            .getObjectById(userOpenidRelationId);
                    if (null == userOpenidRelation) {
                        log.info("userOpenidRelation is not exist");
                        model.addAttribute("code", -2000);
                        return "/common/success";
                    }
                    userOpenidRelation.setOpenId(newMobile);
                    userOpenidRelationService.update(userOpenidRelation);
                }
                CustomerInfo customerInfo = consignmentService
                        .getCustomerInfo(uid.toString());
                Assert.assertNotNull(customerInfo);
                log.info("customerInfo             is            "
                        + customerInfo);
                // PersonalInfoIn personalInfo =
                // consignmentService.modifyPersonalInfo();
                PersonalInfoIn personalInfo = new PersonalInfoIn();
                personalInfo.setFunctionId(9543);
                personalInfo.setFundAccount(customerInfo.getFundAccount());
                personalInfo.setPassword("password");
                personalInfo.setUserId(uid.toString());
                personalInfo.setMobiletelephone(newMobile);
                CommonOut coumonout = consignmentService
                        .modifyPersonalInfo(personalInfo);
                user.setMobile(newMobile);
                userService.update(user);
                model.addAttribute("code", 0);
                return "/common/success";
            } else {
                log.error("wrong verifycode");
                model.addAttribute("code", -1006);

                return "/common/success";
            }

        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update moblie error ");
        }
        return "/common/success";
    }

    /**
     * 10、修改用户手机号 (组织机构和个人)（app）
     */
    @RequestMapping(value = "/a/u/app/user/mobile/{type}", method = RequestMethod.PUT)
    public String updateMoblie(HttpServletRequest request, HttpServletResponse response, ModelMap model, String newMobile,
                               String verify, @PathVariable String type, String paypwd) {

        try {
            Long uid = cookieUtil.getID(request);
            if (null == uid) {
                log.info("no uid");
                model.addAttribute("code", -2000);
                return "/common/success";
            }
            User user = userService.getObjectById(uid);
            if (null == user) {
                log.info("user is null");
                model.addAttribute("code", -2000);
                return "/common/success";
            }
            Long userId = userService.getUserIdByMobile(newMobile);
            if (null != userId) {
                log.info("mobile is exist");
                model.addAttribute("code", -9000);
                return "/common/success";
            }

            if (user.getPayPwd().isEmpty()) {
                log.info("no payPwd");
                model.addAttribute("code", -3016);
                return "/common/success";
            }
            log.info(" inputpass: " + paypwd + "  dbpasswords: " + user.getPayPwd());
            boolean verifyPwd = paypwd.equals(user.getPayPwd().trim());
            log.info(" verifyPwd: " + verifyPwd);
            if (!verifyPwd) {
                log.info(uid + " wrong password " + paypwd);
                model.addAttribute("code", -2004);
                return "/common/success";
            }

            boolean verifyResult = false;

            String verifyType = "register";
            log.info("log1: mobile is " + newMobile + ",type = " + verifyType
                    + ",verify =" + verify);
            verifyResult = verifyMobileCode(model, newMobile, verifyType,
                    verify);

            if (verifyResult) {

                if (Constant.Person_type.equals(type)) {
                    type = UserOpenidRelation.TYPEMOBILE;
                } else {
                    type = UserOpenidRelation.Type_Org_Mobile;
                }

                Long userOpenidRelationId = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(user.getMobile(), type);

                if (null == userOpenidRelationId) {
                    log.info("userOpenidRelationId is not exist");
                    model.addAttribute("code", -2000);
                    return "/common/success";
                }

                UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(userOpenidRelationId);
                if (null == userOpenidRelation) {
                    log.info("userOpenidRelation is not exist");
                    model.addAttribute("code", -2000);
                    return "/common/success";
                }
                userOpenidRelation.setOpenId(newMobile);
                userOpenidRelationService.update(userOpenidRelation);

                CustomerInfo customerInfo = consignmentService
                        .getCustomerInfo(uid.toString());
                Assert.assertNotNull(customerInfo);
                log.info("customerInfo is " + customerInfo);
                // PersonalInfoIn personalInfo =
                // consignmentService.modifyPersonalInfo();
                PersonalInfoIn personalInfo = new PersonalInfoIn();
                personalInfo.setFunctionId(9543);
                personalInfo.setFundAccount(customerInfo.getFundAccount());
                personalInfo.setPassword("password");
                personalInfo.setUserId(uid.toString());
                personalInfo.setMobiletelephone(newMobile);
                CommonOut coumonout = consignmentService
                        .modifyPersonalInfo(personalInfo);
                user.setMobile(newMobile);
                userService.update(user);
                model.addAttribute("code", 0);
                return "/common/success";
            } else {
                log.error("wrong verifycode");
                model.addAttribute("code", -1006);

                return "/common/success";
            }

        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update moblie error ");
        }
        return "/common/success";
    }

    // 11、校验手机号是否激活
    @RequestMapping(value = "/a/mobile/active", method = RequestMethod.GET)
    public String verifyActive(ModelMap model, String mobile, Integer accountType) throws Exception {
        Integer code = 0;
        if (StringUtils.isBlank(mobile)) {
            code = -2001;
        } else {
            try {
                Long relationID = null;
                if (User.TYPE_ORG.equals(accountType)) {
                    relationID = this.userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Org_Mobile);
                    log.info(" ORG  relationID   :" + relationID + "  mobile: " + mobile);
                } else {
                    relationID = this.userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Person_Mobile);
                    log.info(" PERSON relationID :" + relationID + "  mobile: " + mobile);
                }
                if (relationID != null) {
                    // ID存在
                    UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(relationID);
                    Long userId = userOpenidRelation.getTypeId();
                    User user = userService.getObjectById(userId);
                    if (null != user && user.getStatus().equals(User.USER_ACTIVIATE)) {
                        code = -9002;
                    }
                } else {
                    code = -9001;
                }

            } catch (Throwable t) {
                t.printStackTrace();
                log.error(t.getMessage());
                log.error("add user error ");
                model.addAttribute("code", -1);
            }
        }
        log.info("verify the mobile: " + mobile + " accountType " + accountType + " code: " + code);
        model.addAttribute("code", code);
        return "/common/success";
    }


    // 12、校验手机号是否注册
    @RequestMapping(value = "/a/mobile", method = RequestMethod.GET)
    public String verifyNick(ModelMap model, String mobile,
                             Integer accountType) throws Exception {
        log.info("verify the mobile: " + mobile + " accountType " + accountType);
        Integer code = 0;
        if (StringUtils.isBlank(mobile)) {
            code = -2001;
        } else {
            try {
                Long relationID = null;
                if (User.TYPE_ORG.equals(accountType)) {
                    relationID = this.userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Org_Mobile);
                    log.info("ORG  ");
                } else {
                    relationID = this.userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Person_Mobile);
                }
                if (relationID != null) {
                    code = -9000;
                }
            } catch (Throwable t) {
                log.error(t.getMessage());
                log.error("add user error ");
                code = -1;
            }
        }
        model.addAttribute("code", code);
        return "/common/success";
    }

    // 13、校验组织机构代码是否被用过
    @RequestMapping(value = "/a/orgcode", method = RequestMethod.GET)
    public String verifyOrgCode(HttpServletRequest request, HttpServletResponse response, ModelMap model, String orgCode) throws Exception {
        log.info("verify the org code: " + orgCode);
        Integer code = 0;
        if (StringUtils.isBlank(orgCode)) {
            code = -9010;
        } else {
            try {
                List<Long> idLs = orgApplyService.orgCodeIds(orgCode);
                if (CollectionUtils.isNotEmpty(idLs)) {
                    List<OrgApply> orgApplies = orgApplyService.getObjectsByIds(idLs);
                    for (OrgApply orgApply : orgApplies) {
                        if (orgApply.getStatus().equals(OrgApply.STATUS_1) || orgApply.getStatus().equals(OrgApply.STATUS_2)) {
                            code = -9011;
                        }
                    }
                }
            } catch (Throwable t) {
                log.error(t.getMessage());
                log.error("add user error ");
                code = -1;
            }
        }
        model.addAttribute("code", code);
        return "/common/success";
    }

    //14、校验营业许可证是否占用
    @RequestMapping(value = "/a/licensecode", method = RequestMethod.GET)
    public String verifyLicenseCode(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, String licensecode) throws Exception {

        log.info("verify the license code: " + licensecode);
        Integer code = 0;
        if (StringUtils.isBlank(licensecode)) {
            code = -9012;
        } else {
            try {
                List<Long> idLs = orgApplyService.licenseCodeIds(licensecode);
                if (CollectionUtils.isNotEmpty(idLs)) {
                    List<OrgApply> orgApplies = orgApplyService.getObjectsByIds(idLs);
                    for (OrgApply orgApply : orgApplies) {
                        if (orgApply.getStatus().equals(OrgApply.STATUS_1) || orgApply.getStatus().equals(OrgApply.STATUS_2)) {
                            code = -9013;
                        }
                    }
                }
            } catch (Throwable t) {
                log.error(t.getMessage());
                log.error("add user error ");
                code = -1;
            }
        }
        model.addAttribute("code", code);
        return "/common/success";
    }


    // 15、校验社会信用码是否占用
    @RequestMapping(value = "/a/creditcode", method = RequestMethod.GET)
    public String verifyNick(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String creditcode) throws Exception {

        log.info("verify the license code: " + creditcode);
        Integer code = 0;
        if (StringUtils.isBlank(creditcode)) {
            code = -9014;
        } else {
            try {
                List<Long> idLs = orgApplyService.creditCodeIds(creditcode);
                if (CollectionUtils.isNotEmpty(idLs)) {
                    List<OrgApply> orgApplies = orgApplyService.getObjectsByIds(idLs);
                    for (OrgApply orgApply : orgApplies) {
                        if (orgApply.getStatus().equals(OrgApply.STATUS_1) || orgApply.getStatus().equals(OrgApply.STATUS_2)) {
                            code = -9015;
                        }
                    }
                }
            } catch (Throwable t) {
                log.error(t.getMessage());
                log.error("add user error ");
                code = -1;
            }
        }
        model.addAttribute("code", code);
        return "/common/success";
    }


    // 16、校验验证码
    @RequestMapping(value = "/a/user/check/verify/{type}", method = RequestMethod.GET)
    public String checkVerify(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, String mobile,
                              String verify, @PathVariable String type) throws Exception {

        boolean verifyResult = false;

        log.info(mobile + " is mobile ");
        if (mobile == null) {
            model.addAttribute("code", 0);
            return "/common/success";
        }
        try {
            Long uid = userService.getUserIdByMobile(mobile);
            log.info("user id : " + uid);
            try {
                verifyResult = verifyMobileCode(model, mobile, type, verify);
            } catch (Exception e) {
                e.printStackTrace(System.out);
                log.info(" verify error");
                verifyResult = true;
            }
            log.info("verify  " + verifyResult);
//            if (verifyResult) {
            if ("666666".equals(verify) || verifyResult) {
                model.addAttribute("code", 0);
            } else {
                model.addAttribute("code", -1006);
            }
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            log.error(t.getMessage());
            log.error("verify user error ");
        }
        return "/common/success";
    }


    // 17、生成图形验证码
    @RequestMapping(value = "/a/captcha/generate", method = RequestMethod.GET)
    public void captchaGenerate(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model) throws Exception {
        log.info("To captchaGenerate ------------------");
        try {
            // 设置页面不缓存
            response.reset();
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0);
            response.setContentType("image/gif");

            // 生成随机字符
            String randomStr = RandomStringUtils.randomAlphabetic(4)
                    .toUpperCase();
            log.info("randomStr: " + randomStr);
            // 存入cookie
            Cookie cookie = new Cookie(CAPTCHA, MD5Util.getMd5Sum(randomStr));
            cookie.setPath("/");
            cookie.setDomain(cookieUtil.getDomain());
            cookie.setMaxAge(5 * 365 * 24 * 60 * 60);
            response.addCookie(cookie);
            // 生成图片流
            BufferedImage bi = new CaptchaUtil().generate(165, 40, randomStr).getImage();
            // 创建输出流
            OutputStream out = response.getOutputStream();
            // 将图片写入到输出流中去
            ImageIO.write(bi, "JPG", out);
            // 强制刷新
            out.flush();
            // 关闭输出流
            out.close();
        } catch (Exception e) {
            log.error("get captchaGenerate error", e);
            model.addAttribute("code", -1);
        }

    }

    // 18、验证图形验证码
    @RequestMapping(value = "/a/captcha/verify", method = RequestMethod.GET)
    public String captchaVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String inputValue)
            throws Exception {
        log.info("To captchaVerify ------------------");

        log.info("inputValue: " + inputValue);

        try {
            String cookieValue = "";
            try {
                cookieValue = RequestUtil.getCookie(request, CAPTCHA).getValue();
            } catch (Exception e) {
                log.error("got error when getCookie");
            }
            log.info("cookieValue: " + cookieValue);

            if (StringUtils.isBlank(inputValue) || StringUtils.isBlank(cookieValue)) {
                model.addAttribute("code", -1006);
                return "/common/success";
            }

            String md5Value = "";
            try {
                md5Value = MD5Util.getMd5Sum(inputValue.toUpperCase());
            } catch (NoSuchAlgorithmException e) {
                log.error("got error when getMD5");
            }

            log.info("md5Value: " + md5Value);

            if (md5Value.equals(cookieValue)) {
                isCaptcha = true;
                model.addAttribute("code", 0);
            } else {
                isCaptcha = false;
                model.addAttribute("code", -1006);
            }
        } catch (Exception e) {
            log.error("get captchaVerify error", e);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    // 18、用户充值前进行校验  校验用户身份证信息与银行卡信息
    @RequestMapping(value = "/a/u/app/auth/verify", method = RequestMethod.GET)
    public String authVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String idNo, String bank, String bankNo)
            throws Exception {
        log.info("user auth verify");

        log.info("idNo : " + idNo + " bank : " + bank + " bankNo : " + bankNo);

        if (DataUtils.isNullOrEmpty(idNo) || DataUtils.isNullOrEmpty(bank) || DataUtils.isNullOrEmpty(bankNo)) {
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            Boolean idVerify = false;
            Boolean cardVerify = false;
            Boolean result = false;

            Long uid = cookieUtil.getID(request);
            log.info("user id : " + uid);
            User user = userService.getObjectById(uid);

            if (user.getType().equals(User.TYPE_ORG)) {
                log.info("user type org");
                model.addAttribute("code", -2033);
                return "/common/success";
            }

            Person person = personService.getObjectById(uid);
            if (null == person) {
                log.info("user type person but no person object");
                model.addAttribute("code", -2034);
                return "/common/success";
            }

            String turthId = person.getIdNo();

            if (idNo.equals(turthId)) {
                idVerify = true;
            }

            BindingBankIn bindingBankIn = new BindingBankIn();
            bindingBankIn.setUserId(user.getId().toString());
            bindingBankIn.setFundAccount(user.getFundAccount());
            bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
            List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
            for (BindingBank bindingBank : bindingBanks) {
                if (bindingBank.getBankNo().equals(bank) && bankNo.equals(bindingBank.getBankAccount())) {
                    cardVerify = true;
                }
            }

            if(!idVerify){
                log.info("ifVerify false");
                model.addAttribute("code", -2035);
                return "/common/success";
            }

            if(!cardVerify){
                log.info("cardVerify false");
                model.addAttribute("code", -2036);
                return "/common/success";
            }

            if(idVerify && cardVerify){
                result = true;
            }

            model.addAttribute("code", 0);
            model.addAttribute("result", result);

        } catch (Exception e) {
            log.error("get captchaVerify error", e);
            model.addAttribute("code", -1);
        }

        return "/common/success1";
    }


    public BigDecimal caculateRepayTotal(Long uid) throws Exception {
        BigDecimal overTotalRepay = new BigDecimal("0");
        BigDecimal repayLine = new BigDecimal("0");
        BigDecimal overRepay = new BigDecimal("0");
        BigDecimal overRate = new BigDecimal("0");
        BigDecimal supposeRepay = new BigDecimal("0");
        BigDecimal totalRepay = new BigDecimal("0");
        BigDecimal debtCount = new BigDecimal("0");
        BigDecimal rate = new BigDecimal("0");
        BigDecimal dayCount = new BigDecimal("0");
        Long debtStart = 0L;
        Long time = 0L;

        //还款中金额
        List<Long> repayIds = debtApplyService.getDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_REPAY, 0, Integer.MAX_VALUE);
        List<DebtApply> repayApply = debtApplyService.getObjectsByIds(repayIds);
        fundLog.info("get debt repay data is " + repayApply.size());

        for (DebtApply debtApply : repayApply) {
            //借款本金利率
            debtCount = debtApply.getDebtCount();
            rate = debtApply.getRate();

            //获取当前借款时间
            debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
            time = System.currentTimeMillis() - debtStart;
            dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME));

            //加上本息
            supposeRepay = caculate(debtCount, rate, dayCount).add(debtCount);
            totalRepay = totalRepay.add(supposeRepay);
        }

        List<Long> debtApplieIds = debtApplyService.getDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_OVERTIME, 0, Integer.MAX_VALUE);
        List<DebtApply> debtApplys = debtApplyService.getObjectsByIds(debtApplieIds);
        fundLog.info("get debt over time data is " + debtApplys.size());

        for (DebtApply debtApply : debtApplys) {
            //借款本金、利率
            debtCount = debtApply.getDebtCount();
            overRate = debtApply.getOverRate();
            rate = debtApply.getRate();

            //获取总借款利息
            repayLine = new BigDecimal(debtApply.getRepayLine());
            overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);

            //获取当前逾期时间
            debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
            time = System.currentTimeMillis() - debtStart;
            dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);

            //获取当前罚息
            overRepay = caculate(overTotalRepay, overRate, dayCount).add(overTotalRepay);
            totalRepay = totalRepay.add(overRepay);
        }

        return totalRepay;
    }

    //计算利息
    public BigDecimal caculate(BigDecimal debtCount, BigDecimal rate, BigDecimal day) {
        fundLog.info("caculate : debtCount = " + debtCount + " rate = " + rate + " day = " + day);
        BigDecimal result = debtCount.multiply(day).multiply(rate).divide(DebtConstant.HUNDRED, 3, BigDecimal.ROUND_HALF_UP).divide(DebtConstant.YEAR, 3, BigDecimal.ROUND_HALF_UP);
        return result;
    }
}

/**
 * 实名认证
 *
 * @param newUser
 * @param request
 * @param response
 * @return
 * @RequestMapping(value = "/auth", method = RequestMethod.PUT) public String
 * auth(@RequestBody User newUser, HttpServletRequest
 * request, HttpServletResponse response) { Map<String,
 * Object> infoMap = checkAndGetWriter(request, response);
 * PrintWriter writer = (PrintWriter)
 * infoMap.get(WriterKey); Boolean bSuccess = true; try {
 * log.info(" /auth new user: " + newUser); Long uid =
 * getUserId(request); log.info(" /auth  userId " + uid);
 * User user = userService.get(uid); if (null == user) {
 * log.info("user is :" + user); return
 * writeConent(response.getWriter(), response, false,
 * HttpServletResponse.SC_OK, null, null, null, null); }
 * Long ueid = (Long) userExtService.getUse(new
 * Object[]{uid}); UserExt userExt =
 * userExtService.get(ueid); // if(Constants.AUTH_FAIL ==
 * userExt.getauthType()){ //
 * userExtService.remove(userExt.getId()); // }
 * user.setauthType(Constants.AUTH_WAITING);
 * user.setname(newUser.getname()); bSuccess =
 * userService.update(user);
 * System.out.println(" user after auth : " + user +
 * " result : " + bSuccess); // Long ueid = (Long)
 * userExtService.getUse(new Object[]{uid}); if (null ==
 * ueid) { UserExt ext = new UserExt(uid); ueid =
 * userExtService.save(ext); } //
 * System.out.println(" user ext id : " + ueid); //
 * UserExt userExt = userExtService.get(ueid);
 * userExt.setidcard(newUser.getidcard());
 * userExt.setidPicFront(newUser.getidPicFront());
 * userExt.setidPicBack(newUser.getidPicBack());
 * userExt.setcontactPhone(newUser.getcontactPhone());
 * userExt.setauthType(Constants.AUTH_WAITING); bSuccess =
 * userExtService.update(userExt) && bSuccess;
 * log.info(" result is : " + bSuccess); } catch
 * (Exception e) { e.printStackTrace(System.out); } return
 * handleResult(bSuccess,
 * HttpServletResponse.SC_NO_CONTENT, writer, response); }
 */
