package com.ptteng.wealth.user.controller;

import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.*;
import com.ptteng.wealth.consign.model.out.*;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.util.Constant;
import com.ptteng.wealth.util.JinShenUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.naming.Binding;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by arthur on 16/6/27.
 */

@Controller
public class RechargeController extends BaseController {

    public static final Log rechargeLog = LogFactory.getLog("rechargeLog");
    public static final Log onlineRechareLog = LogFactory.getLog("recharge_online_log");

    //    个人用户 证联融通-线上充值通知(107/207)
    @RequestMapping(value = "/a/u/recharge/online")
    public String inputOnline(ModelMap model, Double rechargeAmt, String bankno, String bankAccount, String paypwd, HttpServletRequest request) {
        onlineRechareLog.info("=====================================================");
        onlineRechareLog.info("bankNo :"+bankno+" bankAccount: "+bankAccount+" paypwd: "+paypwd+" money: "+rechargeAmt);

        if(DataUtils.isNullOrEmpty(rechargeAmt) || DataUtils.isNullOrEmpty(bankno) || DataUtils.isNullOrEmpty(paypwd)
                || DataUtils.isNullOrEmpty(bankAccount)){
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        int code = 0;
        try {
            User user = getUser(request);
            if (null == user) {
                code = -2000;
            } else {
                if (null == user.getFundAccount()) {
                    code = -2031;
                } else {
                    onlineRechareLog.info("userid: "+user.getId());
                    Person person = personService.getObjectById(user.getId());
                    RechargeIn organBindCardIn = new RechargeIn();
                    organBindCardIn.setUserId(user.getId() + "");
                    organBindCardIn.setFundAccount(user.getFundAccount());
                    organBindCardIn.setPassword(paypwd);
                    organBindCardIn.setBranchNo(GlobalConstant.BRANCH_NO);
                    organBindCardIn.setUserNameText(user.getName());
                    organBindCardIn.setCertType("0");
                    organBindCardIn.setCertId(person.getIdNo());
                    organBindCardIn.setBankCode(bankno);
                    organBindCardIn.setCardNo(bankAccount);
                    organBindCardIn.setTransAmt(new BigDecimal(rechargeAmt));
                    organBindCardIn.setBusinessType("00");
                    organBindCardIn.setChannelResource("");
                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                    RechargeOut rechargeOut = consignmentService.recharge(organBindCardIn);
                    code = rechargeOut.getErrorNo();
                    onlineRechareLog.info(rechargeOut);
                }
            }

            onlineRechareLog.info(" code: " + code);
            model.addAttribute("code", code);

        } catch (Exception e) {
            e.printStackTrace(System.err);
            onlineRechareLog.info(e.getMessage());
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

//
//    个人/机构用户 证联融通-线下充值通知(107/207)	I	function_id	int	系统功能	ZLRT

    @RequestMapping(value = "/a/u/recharge/input")
    public String queryBuyInfo(Double rechargeAmt, String paymentbankCode, String cardNo, String pwd,
                               HttpServletRequest request, HttpServletResponse response) {


        rechargeLog.info("=====================================================");
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        try {
            User user = getUser(request);
            OfflineRechargeIn offlineRechargeIn = new OfflineRechargeIn();
            offlineRechargeIn.setBranchNo(GlobalConstant.BRANCH_NO);
            offlineRechargeIn.setUserId(user.getId() + "");
            offlineRechargeIn.setFundAccount(user.getFundAccount());
            offlineRechargeIn.setPassword(pwd);


            if (user.getType().equals(User.TYPE_PERSON)) {
                Person person = personService.getObjectById(user.getId());
                offlineRechargeIn.setCertType(Constant.IDKIND_PERSON);
                offlineRechargeIn.setCertId(person.getIdNo());
                offlineRechargeIn.setUserNameText(person.getName());
            } else if (user.getType().equals(User.TYPE_ORG)) {
                Organization organization = organizationService.getObjectById(user.getId());
                rechargeLog.info(" user id = " + user.getId() + " org id= " + organization.getId());
                offlineRechargeIn.setCertType(Constant.IDKIND_ZHENGLIAN);
                offlineRechargeIn.setCertId(organization.getUseCertId());
                offlineRechargeIn.setUserNameText(organization.getName());
            }

            offlineRechargeIn.setRechargeAmt(new BigDecimal(rechargeAmt));
            offlineRechargeIn.setReceibankCode("0105");
            offlineRechargeIn.setPaymentbankCode(paymentbankCode);
            offlineRechargeIn.setCardNo(cardNo);
            offlineRechargeIn.setCardName("开磷");
            offlineRechargeIn.setResv(" ");
            offlineRechargeIn.setBusinessType("00");
            offlineRechargeIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            OfflineRechargeOut offlineRechargeOut = null;

            try {
                offlineRechargeOut = consignmentService.rechargeOffline(offlineRechargeIn);
            } catch (Exception e) {
                rechargeLog.info(e.getMessage());
            }
            rechargeLog.info(" user id = " + user.getId() + " errorcode: " + offlineRechargeOut.getErrorNo() + " info: " + offlineRechargeOut.getErrorInfo() + " code:" + offlineRechargeOut.getRechargeCode());
            objMap.put("rechargeCode", offlineRechargeOut.getRechargeCode());
            objMap.put("code", offlineRechargeOut.getErrorNo());
            objMap.put("message", offlineRechargeOut.getErrorInfo());
            rechargeLog.info("============================================================ \n");
            writeConent(response.getWriter(), response, true, HttpServletResponse.SC_OK, null, null, objMap, errorMap);
        } catch (Exception e) {
            rechargeLog.info(e.getMessage());
        }
        return null;
    }


    //    个人用户 证联融通-线上提现通知(107/207)
    @RequestMapping(value = "/a/u/withdraw/online")
    public String outputOnline(ModelMap model, Double withdrawAmt, String bankno, String bankAccount, String paypwd,
                               Integer type, HttpServletRequest request) {
        onlineRechareLog.info("=====================================================");
        onlineRechareLog.info("bankNo :"+bankno+" bankAccount: "+bankAccount+" paypwd: "+paypwd+" money: "+withdrawAmt+"withdrawType: "+type);

        if(DataUtils.isNullOrEmpty(withdrawAmt) || DataUtils.isNullOrEmpty(bankno) || DataUtils.isNullOrEmpty(paypwd)
                || DataUtils.isNullOrEmpty(bankAccount)){
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        int code = 0;
        try {
            User user = getUser(request);
            if (null == user) {
                code = -2000;
            } else {
                if (null == user.getFundAccount()) {
                    code = -2031;
                } else {
                    onlineRechareLog.info("userid: "+user.getId());
                    Person person = personService.getObjectById(user.getId());
                    WithdrawCashIn withdrawCashIn = new WithdrawCashIn();
                    withdrawCashIn.setUserId(user.getId() + "");
                    withdrawCashIn.setFundAccount(user.getFundAccount());
                    withdrawCashIn.setPassword(paypwd);
                    withdrawCashIn.setBranchNo(GlobalConstant.BRANCH_NO);
                    withdrawCashIn.setUserNameText(user.getName());
                    withdrawCashIn.setCertType("0");
                    withdrawCashIn.setCertId(person.getIdNo());
                    withdrawCashIn.setBankCode(bankno);
                    withdrawCashIn.setCardNo(bankAccount);
                    withdrawCashIn.setTransAmt(new BigDecimal(withdrawAmt));
                    withdrawCashIn.setWithdrawType(type.toString());
                    withdrawCashIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                    WithdrawCashOut withdrawCashOut = consignmentService.withdraw(withdrawCashIn);
                    code = withdrawCashOut.getErrorNo();
                    onlineRechareLog.info(withdrawCashOut);
                }
            }

            onlineRechareLog.info(" code: " + code);
            model.addAttribute("code", code);

        } catch (Exception e) {
            e.printStackTrace(System.err);
            onlineRechareLog.info(e.getMessage());
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

//    /**
//     * gt_fund_password	C10	柜台资金密码			Y
//     * <p>
//     * bank_no_dk	C4	代扣银行代码			Y
//     * bank_account_dk	C32	代扣银行账号			Y
//     * tied_card_type	C1	绑定类别,0 快捷绑卡1 网关绑卡
//     * bank_balance	N19.2	银行卡代扣金额			Y
//     * money_type	C1	币种类别
//     * fund_company	C4	虚拟基金公司
//     * fund_code	C6	虚拟基金代码
//     */
//
//    // 余额支付
//    @RequestMapping(value = "/a/recharge/pay", method = RequestMethod.GET)
//    public String justPay(Double totalfee,String paypwd, HttpServletRequest request, HttpServletResponse response,String token) {
//        HashMap<String, String> errorMap = new HashMap<String, String>();
//        HashMap<String, Object> objMap = new HashMap<String, Object>();
//        Long uid = 0l;
//        try {
//            log.info("  /a/u/recharge/pay  .. ");
//            //第一步： 获取用户信息
//            log.info(" token : " + token);
//            if (StringUtils.isNotBlank(token)) {
//                uid = Long.parseLong(JinShenUtil.parseToken(token));
//                log.info(" token user id : " + uid);
//            } else {
//                uid = cookieUtil.getID(request);
//            }
//            User user = userService.getObjectById(uid);
////            User user = getUser(request);
//            AutoDocBailRechargeOut autoDocBailRechargeOut = null;
//            BindingBank bindingBank = null;
//            try {
//
//                //一.  机构用户处理逻辑
//                if (user.getType().equals(User.TYPE_ORG)) {
//                    BindingBankIn bindingBankIn = new BindingBankIn();
//                    bindingBankIn.setUserId(user.getId() + "");
//                    bindingBankIn.setFundAccount(user.getFundAccount());
//                    bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
//                    List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
//                    for (BindingBank bank : bindingBanks) {
//                        if (bank.getBankNo().equals("ZLRT")) {
//                            bindingBank = bank;
//                            break;
//                        }
//                    }
//                    log.info(" BANK:  "+bindingBank);
//                    AutoDocBailRechargeIn organBindCardIn = new AutoDocBailRechargeIn();
//                    organBindCardIn.setUserId(user.getId() + "");
//                    organBindCardIn.setFundAccount(user.getFundAccount());
//                    organBindCardIn.setPassword(paypwd);
//                    organBindCardIn.setBranchNo(GlobalConstant.BRANCH_NO);
//                    organBindCardIn.setFundAccountG(user.getFundAccount());
//                    organBindCardIn.setOpbusinessFlag("8035");
//                    organBindCardIn.setOccurBalanceG(new BigDecimal(totalfee));
//                    organBindCardIn.setTiedCardType("0");
//                    organBindCardIn.setMoneyType("1");
//                    organBindCardIn.setFundCompany(GlobalConstant.FUND_COMPANY);
//                    organBindCardIn.setFundCode(990006 + "");
//                    organBindCardIn.setPayType("0");
//                    organBindCardIn.setChannelResource("");
//                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
//                    organBindCardIn.setBankNoDk("ZLRT");
//                    organBindCardIn.setBankAccountDk(bindingBank.getBankAccount());
//                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
//                    organBindCardIn.setAutotransNo("");
//                    log.info("organBindCardIn : "+organBindCardIn);
//                    autoDocBailRechargeOut = consignmentService.autoDocBailRecharge(organBindCardIn);
//                }
//                //第一步： 获取用户绑定的证联融通的银行卡
//
//            } catch (Exception e) {
//                e.printStackTrace(System.out);
//            }
//            log.info(autoDocBailRechargeOut);
//            objMap.put("code", autoDocBailRechargeOut.getErrorNo());
//            objMap.put("message", autoDocBailRechargeOut.getErrorInfo());
//            writeConent(response.getWriter(), response, true, HttpServletResponse.SC_OK, null, null, objMap, errorMap);
//        } catch (Exception e) {
//            log.error(e.getMessage());
//            e.printStackTrace(System.out);
//        }
//        return null;
//    }
//    // 余额支付
//    @RequestMapping(value = "/a/u/recharge/pay", method = RequestMethod.GET)
//    public String pay(Double totalfee,String paypwd, HttpServletRequest request, HttpServletResponse response,String token) {
//        HashMap<String, String> errorMap = new HashMap<String, String>();
//        HashMap<String, Object> objMap = new HashMap<String, Object>();
//        Long uid = 0l;
//        try {
//            log.info("  /a/u/recharge/pay  .. ");
//            //第一步： 获取用户信息
//            log.info(" token : " + token);
//            if (StringUtils.isNotBlank(token)) {
//                uid = Long.parseLong(JinShenUtil.parseToken(token));
//                log.info(" token user id : " + uid);
//            } else {
//                uid = cookieUtil.getID(request);
//            }
//            User user = userService.getObjectById(uid);
////            User user = getUser(request);
//            AutoDocBailRechargeOut autoDocBailRechargeOut = null;
//            BindingBank bindingBank = null;
//            try {
//
//                //一.  机构用户处理逻辑
//                if (user.getType().equals(User.TYPE_ORG)) {
//                    BindingBankIn bindingBankIn = new BindingBankIn();
//                    bindingBankIn.setUserId(user.getId() + "");
//                    bindingBankIn.setFundAccount(user.getFundAccount());
//                    bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
//                    List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
//                    for (BindingBank bank : bindingBanks) {
//                        if (bank.getBankNo().equals("ZLRT")) {
//                            bindingBank = bank;
//                            break;
//                        }
//                    }
//                    log.info(" BANK:  "+bindingBank);
//                    AutoDocBailRechargeIn organBindCardIn = new AutoDocBailRechargeIn();
//                    organBindCardIn.setUserId(user.getId() + "");
//                    organBindCardIn.setFundAccount(user.getFundAccount());
//                    organBindCardIn.setPassword(paypwd);
//                    organBindCardIn.setBranchNo(GlobalConstant.BRANCH_NO);
//                    organBindCardIn.setFundAccountG(user.getFundAccount());
//                    organBindCardIn.setOpbusinessFlag("8035");
//                    organBindCardIn.setOccurBalanceG(new BigDecimal(totalfee));
//                    organBindCardIn.setTiedCardType("0");
//                    organBindCardIn.setMoneyType("1");
//                    organBindCardIn.setFundCompany(GlobalConstant.FUND_COMPANY);
//                    organBindCardIn.setFundCode(990006 + "");
//                    organBindCardIn.setPayType("0");
//                    organBindCardIn.setChannelResource("");
//                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
//                    organBindCardIn.setBankNoDk("ZLRT");
//                    organBindCardIn.setBankAccountDk(bindingBank.getBankAccount());
//                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
//                    organBindCardIn.setAutotransNo("");
//                    log.info("organBindCardIn : "+organBindCardIn);
//                    autoDocBailRechargeOut = consignmentService.autoDocBailRecharge(organBindCardIn);
//                }
//                //第一步： 获取用户绑定的证联融通的银行卡
//
//            } catch (Exception e) {
//                e.printStackTrace(System.out);
//            }
//            log.info(autoDocBailRechargeOut);
//            objMap.put("code", autoDocBailRechargeOut.getErrorNo());
//            objMap.put("message", autoDocBailRechargeOut.getErrorInfo());
//            writeConent(response.getWriter(), response, true, HttpServletResponse.SC_OK, null, null, objMap, errorMap);
//        } catch (Exception e) {
//            log.error(e.getMessage());
//            e.printStackTrace(System.out);
//        }
//        return null;
//    }

}
