package com.ptteng.wealth.user.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.user.model.PersonApply;
import com.ptteng.wealth.user.service.PersonApplyService;

/**
 * PersonApply  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class PersonApplyController extends BaseController {
    private static final Log log = LogFactory.getLog(PersonApplyController.class);

    @Autowired
    private PersonApplyService personApplyService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private UserService userService;

    /**
     * 23、提交实名认证
     *
     * @param personApply {"name":"xx","idNo":"xxxx","idFront","xx","idBack":"xx","personIdImg":"xx"}
     */

    @RequestMapping(value = "/a/u/person/apply", method = RequestMethod.POST)
    public String addPersonApplyJson(HttpServletRequest request, ModelMap model, PersonApply personApply) throws Exception {

        log.info("update personApply : personApply= " + personApply);
        int code = 0;

        try {
            if (StringUtil.isEmpty(personApply.getName())
                    || StringUtil.isEmpty(personApply.getIdNo())
                    || StringUtil.isEmpty(personApply.getIdFront())
                    || StringUtil.isEmpty(personApply.getIdBack())
                    || StringUtil.isEmpty(personApply.getPersonIdImg())
                    ) {
                code = -1000;
            } else {
                Long uid = cookieUtil.getID(request);
                User user = userService.getObjectById(uid);
                Person person = personService.getObjectById(user.getId());
                if(null == person){
                    person = new Person();
                    person.setId(uid);
                    personService.insert(person);
                }
                if ( StringUtil.isNotEmpty(person.getIdNo())&&!person.getIdNo().equals(personApply.getIdNo())) {
                    code = -2027;
                } else {
                    Long personApplyId = personApplyService.getPersonApplyIdByUid(uid);
                    log.info(" personApplyId = " + personApplyId);
                    personApply.setUid(uid);
                    personApply.setStatus(PersonApply.STATUS_1);
                    personApply.setMobile(user.getMobile());
                    if (null == personApplyId) {
                        log.info(" personApplyId is null ");
                        //新增
                        personApply.setId(null);
                        personApply.setCreateBy(uid);
                        personApply.setUpdateBy(uid);
                        Long id = personApplyService.insert(personApply);
                        model.addAttribute("id", id);
                    } else {
                        log.info(" personApplyId is not  null ");
                        //修改
                        personApply.setId(personApplyId);
                        personApply.setUpdateBy(uid);
                        PersonApply oldPersonApply = personApplyService.getObjectById(personApplyId);
                        personApply.setCreateAt(oldPersonApply.getCreateAt());
                        personApply.setCreateBy(oldPersonApply.getCreateBy());
                        personApplyService.update(personApply);
                        model.addAttribute("id", personApplyId);
                    }
                }
            }
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("add personApply error ");
            code = -1;
        }

        model.addAttribute("code", code);
        return "/data/json";
    }

}

