package com.ptteng.wealth.product.controller;

import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.consign.constant.FunctionConstants;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.CurrentIncomeRecordIn;
import com.ptteng.wealth.consign.model.out.CurrentIncomeRecord;
import com.ptteng.wealth.finance.model.Product;
import com.ptteng.wealth.finance.service.ProductService;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.util.DebtConstant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.finance.model.UserProductRelation;
import com.ptteng.wealth.finance.service.UserProductRelationService;

/**
 * UserProductRelation  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class UserProductRelationController extends BaseController {
    private static final Log log = LogFactory.getLog(UserProductRelationController.class);

    @Autowired
    private UserProductRelationService userProductRelationService;
    @Autowired
    private ProductService productService;


    /**
     * 我的理财-收益明细
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param pid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/profit/list", method = RequestMethod.GET)
    public String getUserProductRelationIdsByPidJsonList(HttpServletRequest request,
                                                         HttpServletResponse response, ModelMap model, Integer page,
                                                         Integer size, Long pid) throws Exception {
        log.info(" pid = " + pid + " page = " + page + " size = " + size);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("user product : " + pid + " invest reward info");

        try {

            //获取用户信息
            User user = (User) request.getAttribute("user");
            Long uid = user.getId();
            log.info("uid : " + uid);

            if (null == uid) {
                model.addAttribute("code", -1000);
                log.info(" userid : " + uid + " not exist");
                return "/common/success";
            }

            //获取产品信息
            Product product = productService.getObjectById(pid);
            if (null == product) {
                log.info("product not exist");
                model.addAttribute("code", -3034);
                return "/common/success";
            }
            String productNo = product.getProductNo();
            String companyNo = product.getCompanyNo();
            if (null == productNo) {
                log.info("product " + pid + " productNo not exist");
                model.addAttribute("code", -3034);
                return "/common/success";
            }
            model.addAttribute("name", product.getName());

            List<CurrentIncomeRecord> currentIncomeRecords = new ArrayList<>();
            Map<Integer, String> date = new HashMap<>();
            Integer total = 0;

            try {

                // 查询产品收益
                CurrentIncomeRecordIn recordIn = new CurrentIncomeRecordIn();
                recordIn.setCashFundCompany(companyNo);
                recordIn.setCashFundCode(productNo);
                recordIn.setBranchNo(GlobalConstant.BRANCH_NO);
                recordIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                recordIn.setFunctionId(FunctionConstants.getCurrentIncomeRecordCount);
                recordIn.setFundAccount(user.getFundAccount());
                recordIn.setUserId(user.getId() + "");
                recordIn.setStartDate(20130101);
                recordIn.setEndDate(getDate(0));

                log.info("recordIn : " + recordIn);
                currentIncomeRecords = consignmentService.getCurrentIncomeRecord(recordIn);
                log.info("currentIncomeRecords : " + currentIncomeRecords);

                total = consignmentService.getCurrentIncomeRecordCount(recordIn);

                if (!currentIncomeRecords.isEmpty()) {
                    CurrentIncomeRecord currentIncomeRecord = currentIncomeRecords.get(0);

                    if (0 != currentIncomeRecord.getErrorNo()) {
                        model.put("code", currentIncomeRecord.getErrorNo());
                        model.put("message", currentIncomeRecord.getErrorInfo());
                        log.info("error code is " + currentIncomeRecord.getErrorNo());
                        log.info("error info is " + currentIncomeRecord.getErrorInfo());
                        return "/common/pay";
                    }

                    for(CurrentIncomeRecord record : currentIncomeRecords){
                        String initDate = record.getInitDate()+"";
                        String initDateShow = initDate.substring(0, 4) + "-" + initDate.substring(4, 6) + "-" + initDate.substring(6, initDate.length());
                        date.put(record.getInitDate(), initDateShow);
                    }
                }

            } catch (Exception e) {
                e.printStackTrace(System.out);
                log.error(e.getMessage());
            }

            log.info("get userProductRelation count is " + total);
            int totalPage = 1;
            if (total > 0) {
                totalPage = (total - 1) / size + 1;
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("total", total);
            model.addAttribute("date", date);
            model.addAttribute("list", currentIncomeRecords);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userProductRelation list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/userProductRelation/json/userProductRelationListJson";
    }

    @RequestMapping(value = "/a/userProductRelation2 ", method = RequestMethod.GET)
    public String getUserProductRelationIdsByUidJsonList(HttpServletRequest request,
                                                         HttpServletResponse response, ModelMap model, Integer page,
                                                         Integer size, Long uid) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            List<Long> ids = userProductRelationService.getUserProductRelationIdsByUid(uid, start, size);
            log.info("get countUserProductRelationIdsByUid size is " + ids.size());

            List<UserProductRelation> userProductRelationList = userProductRelationService.getObjectsByIds(ids);
            log.info("get userProductRelation data is " + userProductRelationList.size());

            Integer total = userProductRelationService.countUserProductRelationIdsByUid(uid);
            log.info("get userProductRelation count is " + total);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("userProductRelationList", userProductRelationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userProductRelation list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/wealth-finance-service/userProductRelation/json/userProductRelationListJson";
    }


    @RequestMapping(value = "/a/userProductRelation/{id}", method = RequestMethod.GET)
    public String getUserProductRelationJson(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            UserProductRelation userProductRelation = userProductRelationService.getObjectById(id);
            log.info("get userProductRelation data is " + userProductRelation);

            model.addAttribute("code", 0);

            model.addAttribute("userProductRelation", userProductRelation);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userProductRelation error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/wealth-finance-service/userProductRelation/json/userProductRelationDetailJson";
    }

    @RequestMapping(value = "/a/userProductRelation/{id}", method = RequestMethod.PUT)
    public String updateUserProductRelationJson(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model, UserProductRelation userProductRelation) throws Exception {

        log.info("update userProductRelation : userProductRelation= " + userProductRelation);

        try {

            userProductRelationService.update(userProductRelation);

            model.addAttribute("code", 0);

            model.addAttribute("userProductRelation", userProductRelation);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update userProductRelation error,id is  " + userProductRelation.getId());
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }

    @RequestMapping(value = "/a/userProductRelation", method = RequestMethod.POST)
    public String addUserProductRelationJson(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, UserProductRelation userProductRelation) throws Exception {

        log.info("update userProductRelation : userProductRelation= " + userProductRelation);

        try {
            userProductRelation.setId(null);

            userProductRelationService.insert(userProductRelation);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add userProductRelation error ");
            model.addAttribute("code", -6002);
        }

        return "/data/json";
    }

    @RequestMapping(value = "/a/userProductRelation/{id}", method = RequestMethod.DELETE)
    public String deleteUserProductRelationJson(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete userProductRelation : id= " + id);
        try {
            userProductRelationService.delete(id);

            log.info("add userProductRelation success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete userProductRelation error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/a/multi/userProductRelation", method = RequestMethod.GET)
    public String getMultiUserProductRelationJson(HttpServletRequest request,
                                                  HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<UserProductRelation> userProductRelationList = userProductRelationService.getObjectsByIds(idList);
            log.info("get  userProductRelation data is " + userProductRelationList);

            model.addAttribute("code", 0);
            model.addAttribute("total", userProductRelationList.size());

            model.addAttribute("userProductRelationList", userProductRelationList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get userProductRelation error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/wealth-finance-service/userProductRelation/json/userProductRelationListJson";
    }


    public Integer getDate(int day) {
        Date date = new Date(System.currentTimeMillis() + day * DebtConstant.DAILY_TIME);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String updateTime = dateFormat.format(date);
        Integer result = Integer.valueOf(updateTime);
        return result;
    }

}

