package com.ptteng.wealth.product.controller;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;


import com.gemantic.common.util.MyMathUtil;
import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.admin.service.ConstantService;
import com.ptteng.wealth.consign.constant.*;
import com.ptteng.wealth.consign.model.in.*;
import com.ptteng.wealth.consign.model.out.*;
import com.ptteng.wealth.finance.model.Product;
import com.ptteng.wealth.finance.model.ProductDaily;
import com.ptteng.wealth.finance.service.DrawService;
import com.ptteng.wealth.finance.service.ProductDailyService;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.util.Constant;
import com.ptteng.wealth.util.ConsignConstructor;
import com.ptteng.wealth.util.DebtConstant;
import com.ptteng.wealth.util.InvestConstant;
import com.ptteng.wealth.util.WeekCountUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.finance.model.Invest;
import com.ptteng.wealth.finance.service.InvestService;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Invest  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class InvestController extends BaseController {
    private static final Log log = LogFactory.getLog("invest");

    @Autowired
    private InvestService investService;
    @Autowired
    private DrawService drawService;
    @Autowired
    private ProductDailyService productDailyService;

    //3、立即购买页：通过投资金额计算收益和起息日
    @RequestMapping(value = "/a/u/invest/info", method = RequestMethod.GET)
    public String getInvestInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, BigDecimal investment,
                                Long pid) throws Exception {

        log.info("get product : " + pid + " reward and inteAt by investment : " + investment);

        if (null == investment || null == pid) {
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {
            Product product = productService.getObjectById(pid);
            if (null == product) {
                log.info("product not exist");
                model.addAttribute("code", -3034);
                return "/common/success";
            } else {
                log.info("get product : " + pid);
            }

            BigDecimal rate = product.getAnnualYield();
            if (null == rate) {
                log.info("product " + pid + " rate not exist");
                model.addAttribute("code", -3034);
                return "/common/success";
            } else {
                log.info("get rate : " + rate);
            }

            //计算预计日收益
            BigDecimal result = investment.multiply(rate).multiply(rate).divide(DebtConstant.HUNDRED, 3, BigDecimal.ROUND_HALF_UP).divide(DebtConstant.YEAR, 3, BigDecimal.ROUND_HALF_UP);
            log.info("result : " + result);

            //计算预计起息日
            Long inteAt = calculateInteAt(product);
            log.info("inteAt : " + inteAt);

            model.addAttribute("code", 0);
            model.addAttribute("reward", result);
            model.addAttribute("inteAt", inteAt);

        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            log.error("get product " + pid + " reward and inteAt by investment : " + investment + " error ");
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/invest/json/getInvestInfo";
    }

    //4、查询用户的正联余额和银行卡列表
    @RequestMapping(value = "/a/u/invest/fund/info", method = RequestMethod.GET)
    public String getFundInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        log.info("get user invest fund ");

        //第一步： 获取用户信息
        Long uid = getUserId(request);
        User user = userService.getObjectById(uid);
        log.info("userid: " + uid);
        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info(" userid : " + uid + " not exist");
            return "/common/success";
        }
        try {
            BalanceInquiryOut balance = null;
            Person person = new Person();
            Organization organization = new Organization();


            if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                person = personService.getObjectById(user.getId());
            } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                organization = organizationService.getObjectById(user.getId());
            } else {
                model.addAttribute("code", -2037);
                log.info(" user type : " + user.getType() + " wrong");
                return "/common/success";
            }

            BalanceInquiryIn balanceInquiryIn = ConsignConstructor.balanceInquiryInConstructor(user, person, organization);
            log.info("balanceInquiryIn : " + balanceInquiryIn);

            //调用证联获取余额接口
            try {
                balance = consignmentService.getBalance(balanceInquiryIn);
                log.info("balanceInquiryOut : " + balance);
            } catch (Exception e) {
                log.error("getBalance error , balanceInquiryIn : " + balanceInquiryIn);
                e.printStackTrace();
                log.info(e.getMessage());
            }

            //证联余额
            BigDecimal balanceFee = new BigDecimal("0");
            if (null != balance && 0 == balance.getErrorNo()) {
                log.info("balance : " + balance.getTotalAmt());
                model.addAttribute("balance", balance.getTotalAmt());
                balanceFee = balance.getTotalAmt();
            } else {
                model.addAttribute("balance", 0);
            }

            //银行卡列表
            log.info("user " + uid + " card list");
            List<BindingBank> resultBindingLs = new ArrayList<BindingBank>();

            BindingBankIn bindingBankIn = ConsignConstructor.bindingBankInConstructor(user);
            log.info("bindingBankIn is : " + bindingBankIn);
            List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
            for (BindingBank bindingBank : bindingBanks) {
                if (bindingBank.getBankNo().equals("JHB") || bindingBank.getBankNo().equals("XJY") || bindingBank.getBankNo().equals("ZLRT")) {
                    continue;
                }
                resultBindingLs.add(bindingBank);
                log.info("Binding : " + bindingBank);
            }
            model.addAttribute("code", 0);
            model.addAttribute("bindingBanks", resultBindingLs);
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            log.error("get person " + uid + " card list error");
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/invest/json/getInvestFund";
    }


    //7、我的理财-整体信息
//    @RequestMapping(value = "/a/u/whole/invest/info", method = RequestMethod.GET)
//    public String userWholeInvestInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
//
//        //获取用户信息
//        Long uid = getUserId(request);
//        User user = userService.getObjectById(uid);
//        log.info("userid: " + uid);
//        if (null == uid) {
//            model.addAttribute("code", -2000);
//            log.info(" userid : " + uid + " not exist");
//            return "/common/success";
//        }
//
//        log.info("user whole invest info");
//        try {
//
//            try {
//                BigDecimal income_tot = new BigDecimal("0");
//
//                // 查询所有产品
//                CurrentPositionStatIn in = new CurrentPositionStatIn();
//                in.setBranchNo(GlobalConstant.BRANCH_NO);
//                in.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
//                in.setFunctionId(FunctionConstants.getCurrentIncomeRecordCount);
//                in.setFundAccount(user.getFundAccount());
//                in.setUserId(user.getId() + "");
//
//                log.info("getCurrentPositionStat in : " + in);
//                List<CurrentPositionStat> currentPositionStats = consignmentService.getCurrentPositionStat(in);
//                log.info("currentPositionStats : " + currentPositionStats);
//
//                model.addAttribute("currentPositionStats", currentPositionStats);
//
//                for(CurrentPositionStat out : currentPositionStats){
//                    out.getIncomeBalance();
////                    income_tot.add()
//                }
//
//            } catch (Exception e) {
//                e.printStackTrace(System.out);
//                log.error(e.getMessage());
//            }
//
//            model.addAttribute("code", 0);
//
//        } catch (Exception e) {
//            e.printStackTrace(System.out);
//            log.error(e.getMessage());
//            log.error("get user " + uid + " whole invest info error");
//            log.info("EXCEPTION END ========== ");
//            model.addAttribute("code", -1);
//        }
//
//
//        return "/wealth-finance-service/invest/json/wholeInvestInfo";
//    }

    //5、确认支付
    @RequestMapping(value = "/a/u/invest/pay", method = RequestMethod.POST)
    public String investPay(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id, BigDecimal investment,
                            Integer paymentType, String cardNo, String bankName, String payPwd) throws Exception {

        //获取用户信息
        Long uid = getUserId(request);
        User user = userService.getObjectById(uid);
        log.info("userid: " + uid);
        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info(" userid : " + uid + " not exist");
            return "/common/success";
        }

        log.info("invest pay product : " + id + " " + investment + " yuan by paymentType " + paymentType);

        try {

            //校验支付密码
            if (user.getPayPwd().isEmpty()) {
                log.info("no payPwd");
                model.addAttribute("code", -3016);
                return "/common/success";
            }
            log.info(" inputpass: " + payPwd + "  dbpasswords: " + user.getPayPwd());
            boolean verify = payPwd.equals(user.getPayPwd().trim());
            log.info(" verify: " + verify);
            if (!verify) {
                log.info(uid + " wrong password " + payPwd);
                model.addAttribute("code", -2004);
                return "/common/success";
            }

            Product product = productService.getObjectById(id);
            if (null == product) {
                log.info("product not exist");
                model.addAttribute("code", -3034);
                return "/common/success";
            }
            String productNo = product.getProductNo();
            String proCompany = product.getCompanyNo();
            if (null == productNo || null == proCompany) {
                log.info("product " + id + " productNo or proCompany not exist");
                model.addAttribute("code", -3034);
                return "/common/success";
            }

            Long inteDate = calculateInteAt(product);
            log.info("inte date : " + inteDate);
            if(inteDate == 0){
                log.info("holiday info not exist");
                model.addAttribute("code", -700000001);
                return "/common/success";
            }

            //判断用何种方式进行支付
            if (Invest.Pay_Type_fund.equals(paymentType)) {
                log.info("zhenglian fund pay");

                BindingBank bindingBank = null;
                BindingBankIn bindingBankIn = ConsignConstructor.bindingBankInConstructor(user);
                List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
                for (BindingBank bank : bindingBanks) {
                    if (bank.getBankNo().equals("ZLRT")) {
                        bindingBank = bank;
                        break;
                    }
                }

                if (null == bindingBank) {
                    log.info(uid + " not verify ");
                    model.addAttribute("code", -3028);
                    return "/common/success";
                }
                cardNo = bindingBank.getBankAccount();
                bankName = "ZLRT";

            } else if (Invest.Pay_Type_card.equals(paymentType)) {
                if (null == cardNo || null == bankName) {
                    model.addAttribute("code", -6000);
                    log.info("no card no");
                    return "/common/success";
                }

            }

            FundBuyOut fundBuyOut = new FundBuyOut();
            try {

                //购买理财产品参数
                FundBuyIn fundBuyIn = ConsignConstructor.fundBuyInConstructor(user, product, investment, cardNo, bankName);
                log.info("fundBuyIn : " + fundBuyIn);
                fundBuyOut = consignmentService.buyFund(fundBuyIn, user.getMobile());

            } catch (Exception e) {
                e.printStackTrace(System.out);
                log.error(e.getMessage());
            }

            //认购结果
            log.info("fundBuyOut : " + fundBuyOut);
            model.put("code", fundBuyOut.getErrorNo());
            model.put("message", fundBuyOut.getErrorInfo());
            log.info("error code is " + fundBuyOut.getErrorNo());
            log.info("error info is " + fundBuyOut.getErrorInfo());
            if (0 == fundBuyOut.getErrorNo()) {

                productDailyService.addStatisticsDaily(uid, id, investment, ProductDaily.INVEST);
                Long investId = investService.addInvest(uid, id, paymentType, investment, bankName, user.getName(), user.getMobile(), cardNo, inteDate);
                log.info("invest id : " + investId);

                log.info("SUCCESS END ========== ");
                return "/common/success";
            } else {
                log.info("buy invest fail");
                log.info("FAIL ========== ");
            }
            return "/common/pay";

        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.error(e.getMessage());
            log.error("invest pay error");
            log.info("EXCEPTION END ========== ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //8、我的理财-某个产品的详情页（整体信息与收益记录）
    @RequestMapping(value = "/a/u/invest/product/info/{id}", method = RequestMethod.GET)
    public String userInvestInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        //获取用户信息
        Long uid = getUserId(request);
        User user = userService.getObjectById(uid);
        log.info("userid: " + uid);
        if (null == uid) {
            model.addAttribute("code", -1000);
            log.info(" userid : " + uid + " not exist");
            return "/common/success";
        }

        log.info("user product : " + id + " invest info");

        try {
            //获取产品信息
            Product product = productService.getObjectById(id);
            if (null == product) {
                log.info("product not exist");
                model.addAttribute("code", -3034);
                return "/common/success";
            }
            String productNo = product.getProductNo();
            String companyNo = product.getCompanyNo();
            if (null == productNo || null == companyNo) {
                log.info("product " + id + " productNo or companyNo not exist");
                model.addAttribute("code", -3034);
                return "/common/success";
            }

            BigDecimal rate = product.getAnnualYield();
            BigDecimal investTot = new BigDecimal("0");
            BigDecimal rewardTot = new BigDecimal("0");
            BigDecimal reward = new BigDecimal("0");

            try {
                //获取产品整体信息
                BigDecimal income_tot = new BigDecimal("0");

                CurrentPositionStatIn in = ConsignConstructor.currentPositionStatInConstructor(user, product);
                log.info("getCurrentPositionStat in : " + in);
                List<CurrentPositionStat> currentPositionStats = consignmentService.getCurrentPositionStat(in);
                log.info("currentPositionStats : " + currentPositionStats);

                if (CollectionUtils.isNotEmpty(currentPositionStats)) {

                    CurrentPositionStat out = currentPositionStats.get(0);

                    //结果判断
                    if (0 == out.getErrorNo()) {
                        investTot = out.getEnableShare();
                        rewardTot = out.getIncomeBalance();

                    } else {
                        log.info("error code is " + out.getErrorNo());
                        log.info("error info is " + out.getErrorInfo());
                        model.put("code", out.getErrorNo());
                        model.put("message", out.getErrorInfo());

                        log.info("FAIL ========== ");
                        return "/common/pay";
                    }
                }

                // 查询产品收益
                CurrentIncomeRecordIn recordIn = ConsignConstructor.recordInConstructor(user, product);
                log.info("recordIn : " + recordIn);
                List<CurrentIncomeRecord> currentIncomeRecords = consignmentService.getCurrentIncomeRecord(recordIn);
                log.info("currentIncomeRecords : " + currentIncomeRecords);

                if (CollectionUtils.isNotEmpty(currentIncomeRecords)) {
                    CurrentIncomeRecord currentIncomeRecord = currentIncomeRecords.get(0);

                    if (0 == currentIncomeRecord.getErrorNo()) {
                        reward = currentIncomeRecord.getUnsettledBalance();

                    } else {
                        log.info("error code is " + currentIncomeRecord.getErrorNo());
                        log.info("error info is " + currentIncomeRecord.getErrorInfo());
                        model.put("code", currentIncomeRecord.getErrorNo());
                        model.put("message", currentIncomeRecord.getErrorInfo());
                        return "/common/pay";
                    }
                }

            } catch (Exception e) {
                e.printStackTrace(System.out);
                log.error(e.getMessage());
            }

            model.addAttribute("code", 0);
            model.addAttribute("rate", rate);
            model.addAttribute("reward", reward);
            model.addAttribute("rewardTot", rewardTot);
            model.addAttribute("investTot", investTot);

        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.error(e.getMessage());
            log.error("get user " + uid + " product : " + id + " invest info error");
            log.info("EXCEPTION END ========== ");
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/invest/json/investInfo";
    }

    //9、我的理财-购买/赎回记录
    @RequestMapping(value = "/a/u/invest/list", method = RequestMethod.GET)
    public String productInvestBuyInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
                                       Integer type, Integer page, Integer size) throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("pageList : page= " + start + " , size=" + size);

        if(DataUtils.isNullOrEmpty(type) || DataUtils.isNullOrEmpty(id)){
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        //获取用户信息
        Long uid = getUserId(request);
        User user = userService.getObjectById(uid);
        log.info("userid: " + uid);
        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info(" userid : " + uid + " not exist");
            return "/common/success";
        }

        //判断是购买或者赎回记录
        String businessFlag = "";
        if (InvestConstant.type_invest == type) {
            log.info("user prodcut " + id + " invest buy list");
            businessFlag = "22";
        } else {
            log.info("user prodcut " + id + " invest draw list");
            businessFlag = "124";
        }

        try {
            //获取产品详情
            Product product = productService.getObjectById(id);

            if (null == product) {
                log.info("product " + id + " not exist");
                model.addAttribute("code", -3034);
                return "/common/success";
            } else {
                log.info("get product : " + id);
            }

            String proNo = product.getProductNo();
            String proName = product.getName();
            if (null == proNo) {
                log.info("product " + id + " productNo not exist");
                model.addAttribute("code", -3034);
                return "/common/success";
            }

            List<TransactionRecordQueryOut> recordQueryOuts = new ArrayList<>();
            Map<Integer, String> date = new HashMap<>();
            Map<Integer, String> recordType = new HashMap<>();
            recordType.put(22, "申购");
            recordType.put(24, "赎回");
            recordType.put(124, "赎回");
            Integer totalSize = 0;
            Integer totalPage = 0;

            try {
                // 查询理财交易记录接口

                TransactionRecordQueryIn trqi = ConsignConstructor.trqiConstructor(user, product, businessFlag, page, size);
                log.info("trqi : " + trqi);
                recordQueryOuts = consignmentService.queryRecord(trqi);
                log.info("recordQueryOuts : " + recordQueryOuts);
                date = ConsignConstructor.dateFormate(recordQueryOuts);

                TransactionRecordCountIn countIn = ConsignConstructor.countInConstructor(user, product, businessFlag);
                log.info("countIn : " + countIn);
                TransactionRecordCountOut countOut = consignmentService.getRecordCount(countIn);
                log.info("countOut : " + countOut);

                totalSize = countOut.getSumRowcount();
                totalPage = (((totalSize - 1)) / (size)) + 1;

            } catch (Exception e) {
                e.printStackTrace(System.out);
                log.error(e.getMessage());
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("name", proName);
            model.addAttribute("date", date);
            model.addAttribute("recordType", recordType);
            model.addAttribute("recordQueryOuts", recordQueryOuts);

        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.error(e.getMessage());
            log.error("invest buy list error");
            log.info("EXCEPTION END ========== ");
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/invest/json/productBuyList";
    }


    //计算起息日
    public Long calculateInteAt(Product product) throws Exception {

        log.info("calculate inte time");

        Long inteTime = 0L;

        //获取起息日延迟
        if (null == product) {
            return null;
        }
        Integer investDay = product.getInterestStartDate();
        log.info("product investDay : " + investDay);

        Long time = 0L;

        //判断是否为当天，true为当天
        Boolean nextDay = WeekCountUtil.timeCalculate(time);

        if (nextDay) {
            log.info("today");
            time = System.currentTimeMillis();
        } else {
            log.info("next day");
            time = DebtConstant.DAILY_TIME + System.currentTimeMillis();
        }

        //有效申请日
        log.info("per apply time : " + time);
        Long applyDay = constantService.getWorkDay(time);
        log.info("apply time : " + applyDay);
        if (0L == applyDay) {
            log.info("not workDay in year");
            return 0L;
        }

        //预计起息日
        time = DebtConstant.DAILY_TIME * investDay + applyDay;
        log.info("per inte time : " + time);

        //判断预计起息日是否为工作日并获取下一个工作日
        inteTime = constantService.getWorkDay(time);
        log.info("inte time : " + time);
        if (0L == applyDay) {
            log.info("not workDay in year");
            return 0L;
        }

        return inteTime;
    }
}

