package com.ptteng.wealth.product.controller;
import java.math.BigDecimal;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.BindingBankIn;
import com.ptteng.wealth.consign.model.in.RedeemIn;
import com.ptteng.wealth.consign.model.out.BindingBank;
import com.ptteng.wealth.consign.model.out.RedeemOut;
import com.ptteng.wealth.finance.model.Product;
import com.ptteng.wealth.finance.model.ProductDaily;
import com.ptteng.wealth.finance.service.ProductDailyService;
import com.ptteng.wealth.user.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.finance.model.Draw;
import com.ptteng.wealth.finance.service.DrawService;

/**
 * Draw  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class DrawController extends BaseController{
	private static final Log log = LogFactory.getLog(DrawController.class);

	@Autowired
	private DrawService drawService;
	@Autowired
	private ProductDailyService productDailyService;

	//12、确认提现
	@RequestMapping(value = "/a/u/invest/draw", method = RequestMethod.POST)
	public String draw(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long id,
									   Integer drawWay, String cardNo, String bankName, BigDecimal amount, String payPwd) throws Exception {

		//获取用户信息
		Long uid = getUserId(request);
		User user = userService.getObjectById(uid);
		log.info("userid: " + uid);
		if (null == uid) {
			model.addAttribute("code", -2000);
			log.info(" userid : " + uid + " not exist");
			return "/common/success";
		}

		log.info("product : " + id + " invest draw ");

		try {
			//校验支付密码
			if (user.getPayPwd().isEmpty()) {
				log.info("no payPwd");
				model.addAttribute("code", -3016);
				return "/common/success";
			}
			log.info(" inputpass: " + payPwd + "  dbpasswords: " + user.getPayPwd());
			boolean verify = payPwd.equals(user.getPayPwd().trim());
			log.info(" verify: " + verify);
			if (!verify) {
				log.info(uid + " wrong password " + payPwd);
				model.addAttribute("code", -2004);
				return "/common/success";
			}

			Product product = productService.getObjectById(id);
			if (null == product) {
				log.info("product not exist");
				model.addAttribute("code", -3034);
				return "/common/success";
			}
			String proNo = product.getProductNo();
			String proCompany = product.getCompanyNo();
			if (null == proNo) {
				log.info("product " + id + " productNo not exist");
				model.addAttribute("code", -3034);
				return "/common/success";
			}


			//判断用何种方式进行支付
			if (Draw.Draw_Type_fund.equals(drawWay)) {
				log.info("draw to zhenglian fund");

				BindingBank bindingBank = null;
				BindingBankIn bindingBankIn = new BindingBankIn();
				bindingBankIn.setUserId(user.getId() + "");
				bindingBankIn.setFundAccount(user.getFundAccount());
				bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
				List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
				for (BindingBank bank : bindingBanks) {
					if (bank.getBankNo().equals("ZLRT")) {
						bindingBank = bank;
						break;
					}
				}

				if (null == bindingBank) {
					log.info(uid + " not verify ");
					model.addAttribute("code", -3028);
					return "/common/success";
				}
				cardNo = bindingBank.getBankAccount();
				bankName = "ZLRT";

			} else if (Draw.Draw_Type_card.equals(drawWay)) {
				if (null == cardNo || null == bankName) {
					model.addAttribute("code", -6000);
					log.info("no card no");
					return "/common/success";
				}
			}

			RedeemOut redeemOut = new RedeemOut();

			try {
				// 查询理财交易记录接口
				RedeemIn redeemIn = new RedeemIn();
				redeemIn.setUserId(uid + "");
				redeemIn.setBranchNo(GlobalConstant.BRANCH_NO);
				redeemIn.setFundAccount(user.getFundAccount());
				redeemIn.setPassword(user.getPayPwd());
				redeemIn.setBankNoS(bankName);
				redeemIn.setBankAccountS(cardNo);
				redeemIn.setFundCode(proNo);
				redeemIn.setFundCompany(proCompany);
				redeemIn.setAmount(amount);
				redeemIn.setChargeType("0");
				redeemIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
				redeemIn.setOutterSerialNo(System.currentTimeMillis()+"");

				log.info("redeemIn : " + redeemIn);
				redeemOut = consignmentService.redeem(redeemIn);

				log.info("redeemOut : " + redeemOut);

			} catch (Exception e) {
				e.printStackTrace(System.out);
				log.error(e.getMessage());
			}

			model.put("code", redeemOut.getErrorNo());
			model.put("message", redeemOut.getErrorInfo());
			log.info("error code is " + redeemOut.getErrorNo());
			log.info("error info is " + redeemOut.getErrorInfo());
			if (0 == redeemOut.getErrorNo()) {

				Draw draw = new Draw();
				draw.setUid(uid);
				draw.setPaymentType(drawWay);
				draw.setMobile(user.getMobile());
				draw.setName(user.getName());
				draw.setAmount(amount);
				draw.setCardNo(cardNo);
				draw.setPid(id);
				draw.setStatus(Draw.STATUS_COMPLETE);
				log.info("insert draw : " + draw);

				productDailyService.addStatisticsDaily(uid, id, amount, ProductDaily.WITHDRAWL);
				Long drawId = drawService.insert(draw);
				log.info("draw id : " + drawId);

				log.info("SUCCESS END ========== ");
			} else {
				log.info("draw invest fail");
				return "/common/pay";
			}


		} catch (Exception e) {
			e.printStackTrace(System.out);
			log.error(e.getMessage());
			log.error("product : " + id + " invest draw ");
			log.info("EXCEPTION END ========== ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}
	
}

