package com.ptteng.wealth.product.controller;

import com.ptteng.wealth.finance.model.AnnualYield;
import com.ptteng.wealth.finance.service.AnnualYieldService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * AnnualYield  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class AnnualYieldController {
	private static final Log log = LogFactory.getLog(AnnualYieldController.class);

	@Autowired
	private AnnualYieldService annualYieldService;

	public static String getDate(Long time){
		SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd");
		String date = "";
		if(null != time){
			date = dateFormat.format(new Date(time));
		}
		return  date;
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param pid
	 * @return
	 * @throws Exception
	 */
		@RequestMapping(value = "/a/annual/yield/{pid}/list", method = RequestMethod.GET)
	public String getAnnualYieldIdsByProductIdJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,@PathVariable Long pid) throws Exception {
			log.info(" pid = "+pid);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 7;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= annualYieldService.getAnnualYieldIdsByProductId(pid, start, size);
		log.info("get countAnnualYieldIdsByProductId size is " + ids.size());
			if(ids.size()>0){
				List<AnnualYield> annualYieldList = annualYieldService.getObjectsByIds(ids);
				log.info("get annualYield data is " + annualYieldList.size());
				//计算万元收益
				for(AnnualYield annualYield : annualYieldList){
					annualYield.setDate(getDate(annualYield.getStaticAt()));
					annualYield.setProfit(annualYield.getAnnualYield().multiply(new BigDecimal("0.01")).multiply(new BigDecimal("10000")));
				}
				model.addAttribute("annualYieldList", annualYieldList);

			}

			Integer total = annualYieldService.countAnnualYieldIdsByProductId(pid);
			log.info("get annualYield count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);


		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get annualYield list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/wealth-finance-service/annualYield/json/annualYieldListJson";
	}
	
	@RequestMapping(value = "/a/annualYield/{id}", method = RequestMethod.GET)
	public String getAnnualYieldJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			AnnualYield annualYield = annualYieldService.getObjectById(id);
			log.info("get annualYield data is " + annualYield);

			model.addAttribute("code", 0);

			model.addAttribute("annualYield", annualYield);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get annualYield error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/wealth-finance-service/annualYield/json/annualYieldDetailJson";
	}

	@RequestMapping(value = "/a/annualYield/{id}", method = RequestMethod.PUT)
	public String updateAnnualYieldJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, AnnualYield annualYield) throws Exception {
		
		log.info("update annualYield : annualYield= " + annualYield);
		
		try {
			
			annualYieldService.update(annualYield);

			model.addAttribute("code", 0);

			model.addAttribute("annualYield", annualYield);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update annualYield error,id is  " + annualYield.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/annualYield", method = RequestMethod.POST)
	public String addAnnualYieldJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, AnnualYield annualYield) throws Exception {
		
		log.info("update annualYield : annualYield= " + annualYield);
		
		try { 
			annualYield.setId(null);

			annualYieldService.insert(annualYield);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add annualYield error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/annualYield/{id}", method = RequestMethod.DELETE)
	public String deleteAnnualYieldJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete annualYield : id= " + id);
		try {
			annualYieldService.delete(id);

			log.info("add annualYield success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete annualYield error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/annualYield", method = RequestMethod.GET)
	public String getMultiAnnualYieldJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<AnnualYield> annualYieldList = annualYieldService.getObjectsByIds(idList);
			log.info("get  annualYield data is " + annualYieldList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",annualYieldList.size());

			model.addAttribute("annualYieldList", annualYieldList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get annualYield error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/wealth-finance-service/annualYield/json/annualYieldListJson";
	}
	
	
	
	
	
}

